/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.compat.jei;

import com.lothrazar.cyclic.block.generatorfluid.ScreenGeneratorFluid;
import com.lothrazar.cyclic.block.generatoritem.ContainerGeneratorDrops;
import com.lothrazar.cyclic.block.generatoritem.ScreenGeneratorDrops;
import com.lothrazar.cyclic.block.melter.ContainerMelter;
import com.lothrazar.cyclic.block.melter.ScreenMelter;
import com.lothrazar.cyclic.block.packager.ScreenPackager;
import com.lothrazar.cyclic.block.solidifier.ContainerSolidifier;
import com.lothrazar.cyclic.block.solidifier.ScreenSolidifier;
import com.lothrazar.cyclic.block.workbench.ContainerWorkbench;
import com.lothrazar.cyclic.compat.jei.GenfluidRecipeCategory;
import com.lothrazar.cyclic.compat.jei.GenitemRecipeCategory;
import com.lothrazar.cyclic.compat.jei.MelterRecipeCategory;
import com.lothrazar.cyclic.compat.jei.PackagerRecipeCategory;
import com.lothrazar.cyclic.compat.jei.SolidifierRecipeCategory;
import com.lothrazar.cyclic.item.crafting.CraftingBagContainer;
import com.lothrazar.cyclic.item.craftingsimple.CraftingStickContainer;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.UtilString;
import java.util.Collection;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

@JeiPlugin
public class CyclicPluginJEI
implements IModPlugin {
    private static final int PLAYER_INV_SIZE = 36;
    private static final ResourceLocation ID = new ResourceLocation("cyclic", "jei");

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new MelterRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SolidifierRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GenitemRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GenfluidRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new PackagerRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.PACKAGER.get()), new ResourceLocation[]{PackagerRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.crafter), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemRegistry.crafting_bag), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)ItemRegistry.crafting_stick), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.WORKBENCH.get()), new ResourceLocation[]{VanillaRecipeCategoryUid.CRAFTING});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.MELTER), new ResourceLocation[]{MelterRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.SOLIDIFIER), new ResourceLocation[]{SolidifierRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.GENERATOR_ITEM.get()), new ResourceLocation[]{GenitemRecipeCategory.ID});
        registration.addRecipeCatalyst((Object)new ItemStack((IItemProvider)BlockRegistry.GENERATOR_FLUID.get()), new ResourceLocation[]{GenfluidRecipeCategory.ID});
    }

    public void registerRecipes(IRecipeRegistration registry) {
        ClientWorld world = Objects.requireNonNull(Minecraft.func_71410_x().field_71441_e);
        registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(IRecipeType.field_222149_a), PackagerRecipeCategory.ID);
        registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(CyclicRecipeType.MELTER), MelterRecipeCategory.ID);
        registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(CyclicRecipeType.SOLID), SolidifierRecipeCategory.ID);
        registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(CyclicRecipeType.GENERATOR_ITEM), GenitemRecipeCategory.ID);
        registry.addRecipes((Collection)world.func_199532_z().func_241447_a_(CyclicRecipeType.GENERATOR_FLUID), GenfluidRecipeCategory.ID);
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            ItemStack st = new ItemStack((IItemProvider)item);
            if (st.func_190926_b() || !UtilString.isCyclic(item.getRegistryName())) continue;
            registry.addIngredientInfo((Object)st, VanillaTypes.ITEM, new ITextComponent[]{new TranslationTextComponent(item.func_77658_a() + ".guide")});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
        registry.addRecipeClickArea(ScreenMelter.class, 75, 20, 40, 26, new ResourceLocation[]{MelterRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenSolidifier.class, 75, 20, 40, 26, new ResourceLocation[]{SolidifierRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenGeneratorDrops.class, 10, 10, 40, 66, new ResourceLocation[]{GenitemRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenGeneratorFluid.class, 50, 8, 20, 20, new ResourceLocation[]{GenfluidRecipeCategory.ID});
        registry.addRecipeClickArea(ScreenPackager.class, 60, 0, 60, 30, new ResourceLocation[]{PackagerRecipeCategory.ID});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
        registry.addRecipeTransferHandler(ContainerMelter.class, MelterRecipeCategory.ID, 0, 2, 2, 36);
        registry.addRecipeTransferHandler(ContainerSolidifier.class, SolidifierRecipeCategory.ID, 0, 3, 4, 36);
        registry.addRecipeTransferHandler(CraftingBagContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(CraftingStickContainer.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(ContainerWorkbench.class, VanillaRecipeCategoryUid.CRAFTING, 1, 9, 10, 36);
        registry.addRecipeTransferHandler(ContainerGeneratorDrops.class, GenitemRecipeCategory.ID, 0, 1, 1, 36);
    }
}

