/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.wireless.redstone;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.wireless.redstone.ContainerTransmit;
import com.lothrazar.cyclic.block.wireless.redstone.TileWirelessRec;
import com.lothrazar.cyclic.config.ConfigRegistry;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilWorld;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWirelessTransmit
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    private static final String REDSTONE_ID = "redstone_id";
    ItemStackHandler inventory = new ItemStackHandler(9){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() instanceof LocationGpsCard;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private UUID id;

    public TileWirelessTransmit() {
        super(TileRegistry.wireless_transmitter);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerTransmit(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        this.id = tag.func_186855_b(REDSTONE_ID) ? tag.func_186857_a(REDSTONE_ID) : UUID.randomUUID();
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        tag.func_186854_a(REDSTONE_ID, this.id);
        return super.func_189515_b(tag);
    }

    private void toggleTarget(BlockPosDim dimPos) {
        if (dimPos == null || this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos targetPos = dimPos.getPos();
        ServerWorld serverLevel = dimPos.getServerLevel(this.field_145850_b.func_73046_m());
        if (serverLevel == null) {
            ModCyclic.LOGGER.info("Dimension not found " + dimPos.getDimension());
            return;
        }
        if (!serverLevel.func_175707_a(targetPos, targetPos)) {
            ModCyclic.LOGGER.info("DimPos is unloaded" + dimPos);
            return;
        }
        boolean isPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
        if (serverLevel.func_175625_s(targetPos) instanceof TileWirelessRec) {
            TileWirelessRec receiver = (TileWirelessRec)serverLevel.func_175625_s(targetPos);
            if (isPowered) {
                receiver.putPowerSender(this.id);
            } else {
                receiver.removePowerSender(this.id);
            }
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(isPowered)));
    }

    public void func_73660_a() {
        for (int s = 0; s < this.inventory.getSlots(); ++s) {
            BlockPosDim targetPos = this.getTargetInSlot(s);
            if (!UtilWorld.dimensionIsEqual(targetPos, this.field_145850_b) && !((Boolean)ConfigRegistry.TRANSFER_NODES_DIMENSIONAL.get()).booleanValue()) continue;
            this.toggleTarget(targetPos);
        }
    }

    BlockPosDim getTargetInSlot(int s) {
        ItemStack stack = this.inventory.getStackInSlot(s);
        return LocationGpsCard.getPosition(stack);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public float getRed() {
        return 0.89f;
    }

    public float getBlue() {
        return 0.0f;
    }

    public float getGreen() {
        return 0.12f;
    }

    public float getAlpha() {
        return 0.9f;
    }

    public float getThick() {
        return 0.065f;
    }

    static enum Fields {
        RENDER;

    }
}

