/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tank;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.tank.RenderTank;
import com.lothrazar.cyclic.block.tank.TileTank;
import com.lothrazar.cyclic.capability.FluidHandlerCapabilityStack;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class BlockFluidTank
extends BlockBase {
    public static final BooleanProperty TANK_ABOVE = BooleanProperty.func_177716_a((String)"above");
    public static final BooleanProperty TANK_BELOW = BooleanProperty.func_177716_a((String)"below");

    public BlockFluidTank(AbstractBlock.Properties properties) {
        super(properties.harvestTool(ToolType.PICKAXE).func_200943_b(1.2f).func_226896_b_());
        this.setHasFluidInteract();
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return this.calcRedstoneFromFluid(worldIn.func_175625_s(pos));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (!(player.func_213453_ef() || player.func_184586_b(hand).func_77973_b() != this.func_199767_j() || hit.func_216354_b() != Direction.UP && hit.func_216354_b() != Direction.DOWN)) {
            return ActionResultType.PASS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public float func_220080_a(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TANK_ABOVE, TANK_BELOW});
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        boolean tileAbove = world.func_175625_s(pos.func_177984_a()) instanceof TileTank;
        boolean tileBelow = world.func_175625_s(pos.func_177977_b()) instanceof TileTank;
        return (BlockState)((BlockState)state.func_206870_a((Property)TANK_ABOVE, (Comparable)Boolean.valueOf(tileAbove))).func_206870_a((Property)TANK_BELOW, (Comparable)Boolean.valueOf(tileBelow));
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileTank();
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228645_f_());
        ClientRegistry.bindTileEntityRenderer(TileRegistry.tank, RenderTank::new);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        try {
            IFluidHandler storageTile;
            IFluidHandlerItem storage = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            TileEntity container = world.func_175625_s(pos);
            if (storage != null && container != null && (storageTile = (IFluidHandler)container.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null)) != null) {
                storageTile.fill(storage.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error during fill from item ", e);
        }
        state = (BlockState)((BlockState)state.func_206870_a((Property)TANK_ABOVE, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)TANK_BELOW, (Comparable)Boolean.valueOf(false));
        world.func_175656_a(pos, state);
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity ent, ItemStack stackTool) {
        super.func_180657_a(world, player, pos, state, ent, stackTool);
        ItemStack tankStack = new ItemStack((IItemProvider)this);
        if (ent instanceof TileTank) {
            TileTank tile = (TileTank)ent;
            IFluidHandler fluidInStack = (IFluidHandler)tankStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null).orElse(null);
            if (fluidInStack != null) {
                FluidStack fs = tile.tank.getFluidInTank(0);
                ((FluidHandlerCapabilityStack)fluidInStack).setFluid(fs);
            }
        }
        if (!world.field_72995_K) {
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), tankStack));
        }
    }
}

