/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.sprinkler;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.GrowthUtil;
import com.lothrazar.cyclic.util.UtilFluid;
import com.lothrazar.cyclic.util.UtilParticle;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileSprinkler
extends TileEntityBase
implements ITickableTileEntity {
    public static final int CAPACITY = 1000;
    public static ForgeConfigSpec.IntValue TIMER_FULL;
    public static ForgeConfigSpec.IntValue WATERCOST;
    public static ForgeConfigSpec.IntValue RADIUS;
    public final FluidTankBase tank = new FluidTankBase(this, 1000, p -> p.getFluid() == Fluids.field_204546_a);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);
    private int shapeIndex = 0;

    public TileSprinkler() {
        super((TileEntityType)TileRegistry.SPRINKLER.get());
    }

    public void func_73660_a() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = (Integer)TIMER_FULL.get();
        this.grabWater();
        if ((Integer)WATERCOST.get() > 0 && this.tank.getFluidAmount() < (Integer)WATERCOST.get()) {
            return;
        }
        List<BlockPos> shape = UtilShape.squareHorizontalFull(this.field_174879_c, (Integer)RADIUS.get());
        ++this.shapeIndex;
        if (this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        if (this.field_145850_b.field_72995_K && GrowthUtil.isValidGrow(this.field_145850_b, shape.get(this.shapeIndex))) {
            UtilParticle.spawnParticle(this.field_145850_b, (IParticleData)ParticleTypes.field_218425_n, shape.get(this.shapeIndex), 9);
        }
        if (GrowthUtil.tryGrow(this.field_145850_b, shape.get(this.shapeIndex), 1.0)) {
            this.tank.drain((Integer)WATERCOST.get(), IFluidHandler.FluidAction.EXECUTE);
            GrowthUtil.tryGrow(this.field_145850_b, shape.get(this.shapeIndex), 1.0);
        }
    }

    private void grabWater() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockState down = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        if (this.tank.isEmpty() && down.func_177230_c() == Blocks.field_150355_j && down.func_204520_s().func_206889_d()) {
            this.tank.fill(new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.EXECUTE);
            this.field_145850_b.func_175656_a(this.field_174879_c.func_177977_b(), Blocks.field_150350_a.func_176223_P());
            return;
        }
        TileEntity below = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (below != null) {
            UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c, Direction.DOWN, (IFluidHandler)below.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null), 1000);
        }
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        CompoundNBT fluid = tag.func_74775_l("fluid");
        this.tank.readFromNBT(fluid);
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        return super.func_189515_b(tag);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }
}

