/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.spikes;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.spikes.EnumSpikeType;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.UtilSound;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpikesBlock
extends BlockBase
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final double CURSE_CHANCE = 0.2;
    public static final int CURSE_TIME = 160;
    public static final int FIRE_TIME = 20;
    public static final BooleanProperty ACTIVATED = BooleanProperty.func_177716_a((String)"lit");
    private static final float LARGE = 0.9375f;
    private static final float SMALL = 0.0625f;
    private static final VoxelShape NORTH_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SOUTH_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)0.9375);
    private static final VoxelShape EAST_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.9375, (double)15.0, (double)15.0);
    private static final VoxelShape WEST_BOX = Block.func_208617_a((double)0.9375, (double)0.0, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    private static final VoxelShape UP_BOX = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)0.9375, (double)15.0);
    private static final VoxelShape DOWN_BOX = Block.func_208617_a((double)0.0, (double)0.9375, (double)0.0, (double)15.0, (double)15.0, (double)15.0);
    private EnumSpikeType type;

    public SpikesBlock(AbstractBlock.Properties properties, EnumSpikeType type) {
        super(properties.func_200943_b(1.1f).func_226896_b_().func_200942_a());
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    @Override
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228641_d_());
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)) {
            case NORTH: {
                return NORTH_BOX;
            }
            case EAST: {
                return EAST_BOX;
            }
            case SOUTH: {
                return SOUTH_BOX;
            }
            case WEST: {
                return WEST_BOX;
            }
            case UP: {
                return UP_BOX;
            }
            case DOWN: {
                return DOWN_BOX;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    @Deprecated
    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        if (entity instanceof LivingEntity && ((Boolean)state.func_177229_b((Property)ACTIVATED)).booleanValue()) {
            switch (this.type) {
                case CURSE: {
                    this.triggerCurse(worldIn, entity);
                    break;
                }
                case FIRE: {
                    entity.func_70015_d(20);
                    break;
                }
                case PLAIN: {
                    entity.func_70097_a(DamageSource.field_76367_g, 1.0f);
                    break;
                }
            }
        }
    }

    private void triggerCurse(World worldIn, Entity entity) {
        if (worldIn.field_73012_v.nextDouble() < 0.2) {
            LivingEntity living = (LivingEntity)entity;
            switch (worldIn.field_73012_v.nextInt(4)) {
                case 0: {
                    if (living.func_70644_a(Effects.field_76421_d)) break;
                    living.func_195064_c(new EffectInstance(Effects.field_76421_d, 160, 2));
                    break;
                }
                case 1: {
                    if (living.func_70644_a(Effects.field_76437_t)) break;
                    living.func_195064_c(new EffectInstance(Effects.field_76437_t, 160, 2));
                    break;
                }
                case 2: {
                    if (living.func_70644_a(Effects.field_189112_A)) break;
                    living.func_195064_c(new EffectInstance(Effects.field_189112_A, 160, 1));
                    break;
                }
                case 3: {
                    if (living.func_70644_a(Effects.field_76419_f)) break;
                    living.func_195064_c(new EffectInstance(Effects.field_76419_f, 160, 2));
                    break;
                }
                case 4: {
                    entity.func_70097_a(DamageSource.field_76376_m, 1.0f);
                    break;
                }
                case 5: {
                    if (living.func_70644_a(Effects.field_76440_q)) break;
                    living.func_195064_c(new EffectInstance(Effects.field_76440_q, 160, 1));
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!((Boolean)state.func_177229_b((Property)ACTIVATED)).booleanValue() && world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(true)));
            if (!world.field_72995_K) {
                UtilSound.playSoundFromServer((ServerWorld)world, pos, SoundRegistry.SPIKES_ON);
            }
        } else if (((Boolean)state.func_177229_b((Property)ACTIVATED)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false)));
            if (!world.field_72995_K) {
                UtilSound.playSoundFromServer((ServerWorld)world, pos, SoundRegistry.SPIKES_OFF);
            }
        }
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World worldIn = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        boolean isSolid = worldIn.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_200132_m();
        BlockState state = (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
        if (isSolid) {
            return (BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)facing)).func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN)).func_206870_a((Property)ACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208155_H}).func_206894_a(new Property[]{ACTIVATED}).func_206894_a(new Property[]{WATERLOGGED});
    }
}

