/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.miner;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.miner.ContainerMiner;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.item.datacard.BlockStateMatcher;
import com.lothrazar.cyclic.item.datacard.BlockstateCard;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileMiner
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    public static ForgeConfigSpec.IntValue POWERCONF;
    private int shapeIndex = 0;
    static final int SLOT_TOOL = 0;
    static final int SLOT_FILTER = 1;
    static final int MAX_HEIGHT = 64;
    public static final int MAX_SIZE = 12;
    private int height = 32;
    private int radius = 5;
    static final int MAX = 64000;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inventory = new ItemStackHandler(2){

        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.stacks.size()) {
                return ItemStack.field_190927_a;
            }
            return super.getStackInSlot(slot);
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot != 1 || stack.func_77973_b() == ItemRegistry.STATECARD.get();
        }
    };
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private WeakReference<FakePlayer> fakePlayer;
    private boolean isCurrentlyMining;
    private float curBlockDamage;
    private BlockPos targetPos = BlockPos.field_177992_a;
    private boolean directionIsUp = false;

    public TileMiner() {
        super(TileRegistry.MINER);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerMiner(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.radius = tag.func_74762_e("size");
        this.height = tag.func_74762_e("height");
        this.isCurrentlyMining = tag.func_74767_n("isCurrentlyMining");
        this.directionIsUp = tag.func_74767_n("directionIsUp");
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("size", this.radius);
        tag.func_74768_a("height", this.height);
        tag.func_74757_a("isCurrentlyMining", this.isCurrentlyMining);
        tag.func_74757_a("directionIsUp", this.directionIsUp);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.field_145850_b instanceof ServerWorld && this.fakePlayer == null) {
            this.fakePlayer = this.setupBeforeTrigger((ServerWorld)this.field_145850_b, "miner");
        }
        try {
            TileEntityBase.tryEquipItem(this.inventoryCap, this.fakePlayer, 0, Hand.MAIN_HAND);
            List<BlockPos> shape = this.getShape();
            if (shape.size() == 0) {
                return;
            }
            this.setLitProperty(true);
            this.updateMiningProgress(shape);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Miner action error", e);
        }
    }

    private boolean updateMiningProgress(List<BlockPos> shape) {
        if (this.fakePlayer == null) {
            return false;
        }
        if (this.isTargetValid()) {
            this.isCurrentlyMining = true;
        } else {
            this.updateTargetPos(shape);
            this.resetProgress();
        }
        Integer cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return false;
        }
        if (this.isCurrentlyMining) {
            BlockState targetState = this.field_145850_b.func_180495_p(this.targetPos);
            float relative = targetState.func_185903_a((PlayerEntity)this.fakePlayer.get(), (IBlockReader)this.field_145850_b, this.targetPos);
            this.curBlockDamage += relative;
            if (this.curBlockDamage >= 1.0f || relative == 0.0f) {
                boolean harvested = ((FakePlayer)this.fakePlayer.get()).field_71134_c.func_180237_b(this.targetPos);
                if (!harvested) {
                    harvested = this.field_145850_b.func_180495_p(this.targetPos).removedByPlayer(this.field_145850_b, this.field_174879_c, (PlayerEntity)this.fakePlayer.get(), true, this.field_145850_b.func_204610_c(this.field_174879_c));
                }
                if (harvested) {
                    this.energy.extractEnergy(cost, false);
                    this.resetProgress();
                } else {
                    this.field_145850_b.func_175715_c(((FakePlayer)this.fakePlayer.get()).func_110124_au().hashCode(), this.targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
                }
            }
        } else {
            this.field_145850_b.func_175715_c(((FakePlayer)this.fakePlayer.get()).func_110124_au().hashCode(), this.targetPos, (int)(this.curBlockDamage * 10.0f) - 1);
        }
        return false;
    }

    private boolean isTargetValid() {
        if (this.targetPos == null || this.field_145850_b.func_175623_d(this.targetPos) || this.fakePlayer == null) {
            return false;
        }
        BlockState targetState = this.field_145850_b.func_180495_p(this.targetPos);
        if (targetState.field_235705_i_ < 0.0f) {
            return false;
        }
        if (targetState.func_235714_a_(DataTags.MINER_IGNORED)) {
            ModCyclic.LOGGER.info("miner/ignored tag skips " + this.targetPos);
            return false;
        }
        if (targetState.func_204520_s() != null && !targetState.func_204520_s().func_206888_e() && !targetState.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            return false;
        }
        if (!this.isValidFromDatacard(targetState)) {
            return false;
        }
        boolean canHarvest = targetState.canHarvestBlock((IBlockReader)this.field_145850_b, this.targetPos, (PlayerEntity)this.fakePlayer.get());
        if (!canHarvest) {
            // empty if block
        }
        return canHarvest;
    }

    private boolean isValidFromDatacard(BlockState targetState) {
        ItemStack filter = this.inventory.getStackInSlot(1);
        if (filter.func_190926_b()) {
            return true;
        }
        for (BlockStateMatcher m : BlockstateCard.getSavedStates(filter)) {
            if (!m.doesMatch(targetState)) continue;
            return true;
        }
        return false;
    }

    private void updateTargetPos(List<BlockPos> shape) {
        ++this.shapeIndex;
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        this.targetPos = shape.get(this.shapeIndex);
    }

    private void resetProgress() {
        this.isCurrentlyMining = false;
        this.curBlockDamage = 0.0f;
        if (this.fakePlayer != null && this.targetPos != null) {
            this.func_145831_w().func_175715_c(((FakePlayer)this.fakePlayer.get()).func_110124_au().hashCode(), this.targetPos, -1);
        }
    }

    private int heightWithDirection() {
        int diff;
        Direction blockFacing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        int n = diff = this.directionIsUp ? 1 : -1;
        if (blockFacing.func_176740_k().func_200128_b()) {
            diff = blockFacing == Direction.UP ? 1 : -1;
        }
        return diff * this.height;
    }

    public List<BlockPos> getShape() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List<BlockPos> shape = UtilShape.squareHorizontalFull(center, this.radius);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = UtilShape.repeatShapeByHeight(shape, heightWithDirection);
        }
        return shape;
    }

    public List<BlockPos> getShapeHollow() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List<BlockPos> shape = UtilShape.squareHorizontalHollow(center, this.radius);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = UtilShape.repeatShapeByHeight(shape, heightWithDirection);
        }
        if (this.targetPos != null) {
            shape.add(this.targetPos);
        }
        return shape;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case DIRECTION: {
                return this.directionIsUp ? 1 : 0;
            }
            case HEIGHT: {
                return this.height;
            }
            case SIZE: {
                return this.radius;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case DIRECTION: {
                this.directionIsUp = value == 1;
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 64);
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
            }
        }
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT,
        DIRECTION;

    }
}

