/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.harvester;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.harvester.ContainerHarvester;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.HarvestUtil;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileHarvester
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    public static final int MAX_SIZE = 12;
    static final int MAX_ENERGY = 640000;
    public static final int MAX_HEIGHT = 16;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private int radius = 6;
    private int shapeIndex = 0;
    BlockPos targetPos = null;
    private int height = 1;
    private boolean directionIsUp = false;
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 160000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileHarvester() {
        super(TileRegistry.HARVESTER);
        this.timer = 1;
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List<BlockPos> shape = this.getShape();
        this.targetPos = this.getShapeTarget(shape);
        ++this.shapeIndex;
        if (this.targetPos != null && HarvestUtil.tryHarvestSingle(this.field_145850_b, this.targetPos)) {
            this.energy.extractEnergy(cost, false);
        }
    }

    private BlockPos getShapeTarget(List<BlockPos> shape) {
        if (shape.size() == 0) {
            return null;
        }
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
        return shape.get(this.shapeIndex);
    }

    private int heightWithDirection() {
        int diff;
        Direction blockFacing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        int n = diff = this.directionIsUp ? 1 : -1;
        if (blockFacing.func_176740_k().func_200128_b()) {
            diff = blockFacing == Direction.UP ? 1 : -1;
        }
        return diff * this.height;
    }

    public List<BlockPos> getShape() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List<BlockPos> shape = UtilShape.cubeSquareBase(center, this.radius, 0);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = UtilShape.repeatShapeByHeight(shape, heightWithDirection);
        }
        return shape;
    }

    public List<BlockPos> getShapeHollow() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List<BlockPos> shape = UtilShape.squareHorizontalHollow(center, this.radius);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = UtilShape.repeatShapeByHeight(shape, heightWithDirection);
        }
        if (this.targetPos != null) {
            shape.add(this.targetPos);
        }
        return shape;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case SIZE: {
                return this.radius;
            }
            case HEIGHT: {
                return this.height;
            }
            case DIRECTION: {
                return this.directionIsUp ? 1 : 0;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
                break;
            }
            case DIRECTION: {
                this.directionIsUp = value == 1;
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 16);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.radius = tag.func_74762_e("radius");
        this.height = tag.func_74762_e("height");
        this.directionIsUp = tag.func_74767_n("directionIsUp");
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_74768_a("radius", this.radius);
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        tag.func_74768_a("height", this.height);
        tag.func_74757_a("directionIsUp", this.directionIsUp);
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        return super.func_189515_b(tag);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerHarvester(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT,
        DIRECTION;

    }
}

