/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatoritem;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.generatoritem.TileGeneratorDrops;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeGeneratorItem<TileEntityBase>
extends CyclicRecipe {
    private NonNullList<Ingredient> ingredients = NonNullList.func_191196_a();
    private int ticks;
    private int rfpertick;
    public static final SerializeGenerateItem SERIALGENERATOR = new SerializeGenerateItem();

    public RecipeGeneratorItem(ResourceLocation id, Ingredient in, int ticks, int rfpertick) {
        super(id);
        this.ingredients.add((Object)in);
        this.setTicks(Math.max(1, ticks));
        this.rfpertick = Math.max(1, rfpertick);
    }

    public boolean matches(TileEntityBase inv, World worldIn) {
        try {
            TileGeneratorDrops tile = (TileGeneratorDrops)inv;
            return this.matches(tile.inputSlots.getStackInSlot(0), (Ingredient)this.ingredients.get(0));
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.field_193370_a) {
            return current.func_190926_b();
        }
        if (current.func_190926_b()) {
            return ing == Ingredient.field_193370_a;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.func_193365_a();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    @Override
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public IRecipeType<?> func_222127_g() {
        return CyclicRecipeType.GENERATOR_ITEM;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return SERIALGENERATOR;
    }

    public int getTicks() {
        return this.ticks;
    }

    public void setTicks(int ticks) {
        this.ticks = ticks;
    }

    public int getRfpertick() {
        return this.rfpertick;
    }

    public void setRfpertick(int rfpertick) {
        this.rfpertick = rfpertick;
    }

    public int getRfTotal() {
        return this.getRfpertick() * this.getTicks();
    }

    public static class SerializeGenerateItem
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeGeneratorItem<? extends TileEntityBase>> {
        SerializeGenerateItem() {
            this.setRegistryName(new ResourceLocation("cyclic", "generator_item"));
        }

        public RecipeGeneratorItem<? extends TileEntityBase> read(ResourceLocation recipeId, JsonObject json) {
            RecipeGeneratorItem r = null;
            try {
                Ingredient inputFirst = Ingredient.func_199802_a((JsonElement)JSONUtils.func_152754_s((JsonObject)json, (String)"fuel"));
                JsonObject result = json.get("energy").getAsJsonObject();
                int ticks = result.get("ticks").getAsInt();
                int rfpertick = result.get("rfpertick").getAsInt();
                r = new RecipeGeneratorItem(recipeId, inputFirst, ticks, rfpertick);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe" + recipeId, e);
            }
            ModCyclic.LOGGER.info("Recipe loaded " + r.func_199560_c().toString());
            return r;
        }

        public RecipeGeneratorItem read(ResourceLocation recipeId, PacketBuffer buffer) {
            RecipeGeneratorItem r = new RecipeGeneratorItem(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readInt(), buffer.readInt());
            return r;
        }

        public void write(PacketBuffer buffer, RecipeGeneratorItem recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            zero.func_199564_a(buffer);
            buffer.writeInt(recipe.getTicks());
            buffer.writeInt(recipe.rfpertick);
        }
    }
}

