/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fanslab;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.fanslab.TileFanSlab;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class BlockFanSlab
extends BlockBase
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.field_208157_J;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.field_208158_K;
    protected static final VoxelShape AABB_CEILING_X_ON = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_CEILING_Z_ON = Block.func_208617_a((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_FLOOR_X_ON = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape AABB_FLOOR_Z_ON = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape AABB_NORTH_ON = Block.func_208617_a((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SOUTH_ON = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape AABB_WEST_ON = Block.func_208617_a((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_EAST_ON = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_CEILING_X_OFF = Block.func_208617_a((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_CEILING_Z_OFF = Block.func_208617_a((double)5.0, (double)14.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0);
    protected static final VoxelShape AABB_FLOOR_X_OFF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape AABB_FLOOR_Z_OFF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape AABB_NORTH_OFF = Block.func_208617_a((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SOUTH_OFF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape AABB_WEST_OFF = Block.func_208617_a((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_EAST_OFF = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);

    public BlockFanSlab(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(0.8f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(FACE, (Comparable)AttachFace.WALL));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        boolean powered = (Boolean)state.func_177229_b((Property)POWERED);
        switch ((AttachFace)state.func_177229_b(FACE)) {
            case FLOOR: {
                if (direction.func_176740_k() == Direction.Axis.X) {
                    return powered ? AABB_FLOOR_X_ON : AABB_FLOOR_X_OFF;
                }
                return powered ? AABB_FLOOR_Z_ON : AABB_FLOOR_Z_OFF;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return powered ? AABB_EAST_ON : AABB_EAST_OFF;
                    }
                    case WEST: {
                        return powered ? AABB_WEST_ON : AABB_WEST_OFF;
                    }
                    case SOUTH: {
                        return powered ? AABB_SOUTH_ON : AABB_SOUTH_OFF;
                    }
                }
                return powered ? AABB_NORTH_ON : AABB_NORTH_OFF;
            }
        }
        if (direction.func_176740_k() == Direction.Axis.X) {
            return powered ? AABB_CEILING_X_ON : AABB_CEILING_X_OFF;
        }
        return powered ? AABB_CEILING_Z_ON : AABB_CEILING_Z_OFF;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228641_d_());
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileFanSlab();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        for (Direction direction : context.func_196009_e()) {
            BlockState blockstate = direction.func_176740_k() == Direction.Axis.Y ? (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f()) : (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACE, (Comparable)AttachFace.WALL)).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)direction.func_176734_d());
            if (!blockstate.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) continue;
            return (BlockState)blockstate.func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
        }
        return null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HORIZONTAL_FACING}).func_206894_a(new Property[]{POWERED}).func_206894_a(new Property[]{FACE}).func_206894_a(new Property[]{WATERLOGGED});
    }
}

