/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.facade.light;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.facade.ITileFacade;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileLightFacade
extends TileEntityBase
implements ITileFacade {
    ItemStackHandler notInventory = new ItemStackHandler(1);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.notInventory);
    private CompoundNBT facadeState = null;

    public TileLightFacade() {
        super(TileRegistry.light_camo);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.loadFacade(tag);
        super.func_230337_a_(bs, tag);
        this.notInventory.deserializeNBT(tag.func_74775_l("inv"));
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.notInventory.serializeNBT());
        this.saveFacade(tag);
        return super.func_189515_b(tag);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public List<BlockPos> getShape() {
        ArrayList<BlockPos> lis = new ArrayList<BlockPos>();
        lis.add(this.field_174879_c);
        return lis;
    }

    @Override
    public CompoundNBT getFacade() {
        return this.facadeState;
    }

    @Override
    public void setFacade(CompoundNBT facadeState) {
        this.facadeState = facadeState;
    }
}

