/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.enderctrl.EnderShelfHelper;
import com.lothrazar.cyclic.block.enderctrl.TileEnderCtrl;
import com.lothrazar.cyclic.block.endershelf.EnderShelfRenderer;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilBlockstates;
import com.lothrazar.cyclic.util.UtilEnchant;
import com.lothrazar.cyclic.util.UtilItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class BlockEnderShelf
extends BlockBase {
    public BlockEnderShelf(AbstractBlock.Properties properties, boolean isController) {
        super(properties.func_200943_b(1.2f).func_226896_b_());
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return Blocks.field_150342_X.getEnchantPowerBonus(Blocks.field_150342_X.func_176223_P(), world, pos);
    }

    @Override
    public void registerClient() {
        ClientRegistry.bindTileEntityRenderer(TileRegistry.ender_shelf, EnderShelfRenderer::new);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEnderShelf();
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(!state.hasTileEntity() || state.func_203425_a(newState.func_177230_c()) && newState.hasTileEntity())) {
            worldIn.func_175713_t(pos);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (hand != Hand.MAIN_HAND && heldItem.func_190926_b()) {
            return ActionResultType.PASS;
        }
        TileEnderShelf shelf = this.getTileEntity(world, pos);
        if (heldItem.func_77973_b().func_206844_a(DataTags.WRENCH)) {
            shelf.toggleShowText();
            player.func_184609_a(hand);
            return ActionResultType.PASS;
        }
        Direction face = hit.func_216354_b();
        Vector3d hitVec = hit.func_216347_e();
        int slot = BlockEnderShelf.getSlotFromHitVec(pos, face, hitVec);
        if (hit.func_216354_b() == state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
            if (heldItem.func_77973_b() == Items.field_151134_bR) {
                ItemStack stackInSlot = shelf.inventory.getStackInSlot(slot);
                if ((stackInSlot == ItemStack.field_190927_a || UtilEnchant.doBookEnchantmentsMatch(stackInSlot, heldItem)) && !world.field_72995_K) {
                    ItemStack remaining = shelf.inventory.insertItem(slot, heldItem, false);
                    player.func_184611_a(hand, remaining);
                    player.func_184609_a(hand);
                    return ActionResultType.SUCCESS;
                }
            } else if (heldItem.func_190926_b()) {
                ItemStack retrievedBook = shelf.inventory.extractItem(slot, 1, false);
                player.func_184611_a(hand, retrievedBook);
                player.func_184609_a(hand);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public static int getSlotFromHitVec(BlockPos pos, Direction face, Vector3d hitVec) {
        double normalizedY = hitVec.func_82617_b() - (double)pos.func_177956_o();
        return (int)Math.floor(normalizedY / 0.2);
    }

    public TileEnderShelf getTileEntity(World world, BlockPos pos) {
        return (TileEnderShelf)world.func_175625_s(pos);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)UtilBlockstates.getFacingFromEntityHorizontal(pos, entity)), 2);
        }
        TileEntity tileentity = world.func_175625_s(pos);
        TileEnderShelf shelf = (TileEnderShelf)tileentity;
        BlockPos controllerPos = EnderShelfHelper.findConnectedController(world, pos);
        if (controllerPos != null) {
            TileEnderCtrl controller = (TileEnderCtrl)world.func_175625_s(controllerPos);
            if (controllerPos != null && controller != null) {
                controller.getShelves().add(pos);
            }
        }
        if (stack.func_77978_p() != null) {
            shelf.inventory.deserializeNBT(stack.func_77978_p());
        }
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity tileentity, ItemStack stackToolUsed) {
        super.func_180657_a(world, player, pos, state, tileentity, stackToolUsed);
        ItemStack newStack = new ItemStack((IItemProvider)this);
        if (tileentity instanceof TileEnderShelf) {
            TileEnderShelf shelf = (TileEnderShelf)tileentity;
            CompoundNBT tileData = shelf.inventory.serializeNBT();
            newStack.func_77982_d(tileData);
        }
        UtilItemStack.dropItemStackMotionless(world, pos, newStack);
    }
}

