/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderitemshelf;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.enderitemshelf.ClientAutoSyncItemHandler;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemShelf
extends TileEntityBase {
    public final ItemStackHandler inventory = new ClientAutoSyncItemHandler(this, 5);
    private final LazyOptional<ItemStackHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    public TileEnderShelf.RenderTextType renderStyle = TileEnderShelf.RenderTextType.STACK;

    public TileItemShelf() {
        super((TileEntityType)TileRegistry.ENDER_ITEM_SHELF.get());
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        if (tag.func_74764_b("RenderTextType")) {
            int rt = tag.func_74762_e("RenderTextType");
            this.renderStyle = TileEnderShelf.RenderTextType.values()[rt];
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("RenderTextType", this.renderStyle.ordinal());
        return super.func_189515_b(tag);
    }

    public void toggleShowText() {
        int ord = this.renderStyle.ordinal() + 1;
        if (ord == TileEnderShelf.RenderTextType.values().length) {
            ord = 0;
        }
        this.renderStyle = TileEnderShelf.RenderTextType.values()[ord];
    }
}

