/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderitemshelf;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.enderitemshelf.ItemShelfRenderer;
import com.lothrazar.cyclic.block.enderitemshelf.TileItemShelf;
import com.lothrazar.cyclic.block.endershelf.BlockEnderShelf;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilBlockstates;
import com.lothrazar.cyclic.util.UtilItemStack;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class BlockItemShelf
extends BlockBase {
    public BlockItemShelf(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(0.8f).func_226896_b_());
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        return Container.func_178144_a((TileEntity)worldIn.func_175625_s(pos));
    }

    @Override
    public void registerClient() {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)TileRegistry.ENDER_ITEM_SHELF.get()), ItemShelfRenderer::new);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileItemShelf();
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!(!state.hasTileEntity() || state.func_203425_a(newState.func_177230_c()) && newState.hasTileEntity())) {
            worldIn.func_175713_t(pos);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (hand != Hand.MAIN_HAND) {
            return ActionResultType.PASS;
        }
        TileItemShelf shelf = this.getTileEntity(world, pos);
        if (heldItem.func_77973_b().func_206844_a(DataTags.WRENCH)) {
            shelf.toggleShowText();
            player.func_184609_a(hand);
            return ActionResultType.PASS;
        }
        Direction face = hit.func_216354_b();
        Vector3d hitVec = hit.func_216347_e();
        int slot = BlockEnderShelf.getSlotFromHitVec(pos, face, hitVec);
        if (hit.func_216354_b() == state.func_177229_b((Property)BlockStateProperties.field_208157_J)) {
            ItemStack shelfStack = shelf.inventory.getStackInSlot(slot);
            if (shelfStack.func_190926_b() || heldItem.func_77973_b() == shelfStack.func_77973_b()) {
                boolean oldEmpty = shelfStack.func_190926_b();
                ItemStack remaining = shelf.inventory.insertItem(slot, heldItem, false);
                world.func_175666_e(pos, shelf.func_195044_w().func_177230_c());
                if (remaining.func_190926_b() || remaining.func_190916_E() != shelfStack.func_190916_E()) {
                    player.func_184611_a(hand, remaining);
                    player.func_184609_a(hand);
                    UtilSound.playSound((Entity)player, SoundRegistry.CRACKLE, oldEmpty ? 0.3f : 0.1f, 0.3f);
                    return ActionResultType.CONSUME;
                }
            }
            if (heldItem.func_190926_b()) {
                int q = player.func_213453_ef() ? 1 : 64;
                ItemStack retrieved = shelf.inventory.extractItem(slot, q, false);
                world.func_175666_e(pos, shelf.func_195044_w().func_177230_c());
                player.func_184611_a(hand, retrieved);
                player.func_184609_a(hand);
            }
            if (!shelfStack.func_190926_b() && !heldItem.func_190926_b()) {
                ItemStack forShelf = heldItem.func_77946_l();
                ItemStack forPlayer = shelf.inventory.extractItem(slot, 64, false);
                player.func_184611_a(hand, forPlayer);
                player.func_184609_a(hand);
                shelf.inventory.insertItem(slot, forShelf, false);
                world.func_175666_e(pos, shelf.func_195044_w().func_177230_c());
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public TileItemShelf getTileEntity(World world, BlockPos pos) {
        return (TileItemShelf)world.func_175625_s(pos);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)UtilBlockstates.getFacingFromEntityHorizontal(pos, entity)), 2);
        }
        TileEntity tileentity = world.func_175625_s(pos);
        TileItemShelf shelf = (TileItemShelf)tileentity;
        if (stack.func_77978_p() != null) {
            shelf.inventory.deserializeNBT(stack.func_77978_p());
        }
    }

    public void func_180657_a(World world, PlayerEntity player, BlockPos pos, BlockState state, TileEntity tileentity, ItemStack stackToolUsed) {
        super.func_180657_a(world, player, pos, state, tileentity, stackToolUsed);
        ItemStack newStack = new ItemStack((IItemProvider)this);
        if (tileentity instanceof TileItemShelf) {
            TileItemShelf shelf = (TileItemShelf)tileentity;
            CompoundNBT tileData = shelf.inventory.serializeNBT();
            newStack.func_77982_d(tileData);
        }
        UtilItemStack.dropItemStackMotionless(world, pos, newStack);
    }
}

