/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderctrl;

import com.lothrazar.cyclic.base.BlockBase;
import com.lothrazar.cyclic.block.enderctrl.EnderShelfHelper;
import com.lothrazar.cyclic.block.enderctrl.TileEnderCtrl;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.util.UtilBlockstates;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockEnderCtrl
extends BlockBase {
    public BlockEnderCtrl(AbstractBlock.Properties properties, boolean isController) {
        super(properties.func_200943_b(1.0f));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEnderCtrl();
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)UtilBlockstates.getFacingFromEntityHorizontal(pos, entity)), 2);
            TileEnderCtrl ctrl = (TileEnderCtrl)world.func_175625_s(pos);
            if (ctrl != null) {
                Set<BlockPos> shlf = EnderShelfHelper.findConnectedShelves(world, pos, ctrl.getCurrentFacing());
                ctrl.setShelves(shlf);
            }
        }
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        boolean isCurrentlyShelf = EnderShelfHelper.isShelf(state);
        boolean isNewShelf = EnderShelfHelper.isShelf(newState);
        TileEnderCtrl ctrl = (TileEnderCtrl)worldIn.func_175625_s(pos);
        if (isCurrentlyShelf && !isNewShelf && ctrl != null) {
            Set<BlockPos> shlf = EnderShelfHelper.findConnectedShelves(worldIn, pos, ctrl.getCurrentFacing());
            ctrl.setShelves(shlf);
        }
        if (state.func_177230_c() != newState.func_177230_c()) {
            worldIn.func_175713_t(pos);
            worldIn.func_175666_e(pos, (Block)this);
        }
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (hand != Hand.MAIN_HAND && heldItem.func_190926_b()) {
            return ActionResultType.PASS;
        }
        if (heldItem.func_77973_b().func_206844_a(DataTags.WRENCH)) {
            TileEnderCtrl contrl = (TileEnderCtrl)world.func_175625_s(pos);
            contrl.toggleShowText();
            TileEnderShelf.RenderTextType nt = contrl.renderStyle;
            for (BlockPos shelf : contrl.getShelves()) {
                TileEntity shelfy = world.func_175625_s(shelf);
                if (!(shelfy instanceof TileEnderShelf)) continue;
                ((TileEnderShelf)shelfy).renderStyle = nt;
            }
            player.func_184609_a(Hand.MAIN_HAND);
            return ActionResultType.PASS;
        }
        if (heldItem.func_77973_b() == Items.field_151134_bR) {
            world.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.insertIntoController(player, hand, heldItem, (IItemHandler)h));
        }
        return ActionResultType.CONSUME;
    }

    private void insertIntoController(PlayerEntity player, Hand hand, ItemStack heldItem, IItemHandler controller) {
        Map allofthem = EnchantmentHelper.func_82781_a((ItemStack)heldItem);
        if (allofthem == null || allofthem.size() == 0) {
            return;
        }
        if (allofthem.size() == 1) {
            ItemStack insertResult = controller.insertItem(0, heldItem, false);
            player.func_184611_a(hand, insertResult);
        } else {
            Enchantment[] flatten;
            for (Enchantment entry : flatten = allofthem.keySet().toArray(new Enchantment[0])) {
                ItemStack fake = new ItemStack((IItemProvider)Items.field_151134_bR);
                EnchantedBookItem.func_92115_a((ItemStack)fake, (EnchantmentData)new EnchantmentData(entry, ((Integer)allofthem.get(entry)).intValue()));
                ItemStack insertResult = controller.insertItem(0, fake, false);
                if (!insertResult.func_190926_b()) continue;
                allofthem.remove(entry);
            }
            if (allofthem.isEmpty()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            } else {
                ItemStack newFake = new ItemStack((IItemProvider)Items.field_151134_bR);
                for (Enchantment newentry : allofthem.keySet()) {
                    EnchantedBookItem.func_92115_a((ItemStack)newFake, (EnchantmentData)new EnchantmentData(newentry, ((Integer)allofthem.get(newentry)).intValue()));
                }
                player.func_184611_a(hand, newFake);
            }
        }
    }
}

