/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.crafter;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.crafter.ContainerCrafter;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.capability.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCrafter
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 64000;
    public static final int TIMER_FULL = 40;
    public static ForgeConfigSpec.IntValue POWERCONF;
    private CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputHandler = new ItemStackHandler(10);
    ItemStackHandler outHandler = new ItemStackHandler(10);
    private final LazyOptional<IItemHandler> input = LazyOptional.of(() -> this.inputHandler);
    private final LazyOptional<IItemHandler> output = LazyOptional.of(() -> this.outHandler);
    private final LazyOptional<IItemHandler> gridCap = LazyOptional.of(() -> new ItemStackHandler(9));
    private final LazyOptional<IItemHandler> preview = LazyOptional.of(() -> new ItemStackHandler(1));
    private ItemStackHandlerWrapper inventoryWrapper = new ItemStackHandlerWrapper(this.inputHandler, this.outHandler);
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventoryWrapper);
    public static final int IO_NUM_ROWS = 5;
    public static final int IO_NUM_COLS = 2;
    public static final int GRID_NUM_ROWS = 3;
    public static final int GRID_NUM_COLS = 3;
    public static final int IO_SIZE = 10;
    public static final int GRID_SIZE = 9;
    public static final int PREVIEW_SLOT = 29;
    public static final int OUTPUT_SLOT_START = 19;
    public static final int OUTPUT_SLOT_STOP = 28;
    public static final int GRID_SLOT_START = 10;
    public static final int GRID_SLOT_STOP = 18;
    private boolean hasValidRecipe = false;
    public boolean shouldSearch = true;
    private ArrayList<ItemStack> lastRecipeGrid = null;
    private IRecipe<?> lastValidRecipe = null;
    private ItemStack recipeOutput = ItemStack.field_190927_a;
    private final CraftingInventory craftMatrix = new CraftingInventory((Container)new FakeContainer(ContainerType.field_221518_l, 18291238), 3, 3);

    public TileCrafter() {
        super(TileRegistry.crafter);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index != 29 && (index < 19 || index > 28)) {
            super.func_94041_b(index, stack);
        }
        return false;
    }

    public void func_73660_a() {
        this.syncEnergy();
        if (this.field_145850_b == null || this.field_145850_b.func_73046_m() == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IItemHandler previewHandler = (IItemHandler)this.preview.orElse(null);
        ArrayList<ItemStack> itemStacksInGrid = this.getItemsInCraftingGrid();
        if (this.lastRecipeGrid == null) {
            this.lastRecipeGrid = itemStacksInGrid;
        }
        if (itemStacksInGrid == null || this.countNonEmptyStacks(itemStacksInGrid) == 0) {
            this.setPreviewSlot(previewHandler, ItemStack.field_190927_a);
            this.timer = 40;
            return;
        }
        if (!itemStacksInGrid.equals(this.lastRecipeGrid)) {
            this.reset();
            this.lastRecipeGrid = itemStacksInGrid;
            this.shouldSearch = true;
        }
        if (!this.hasValidRecipe && this.shouldSearch) {
            IRecipe<?> recipe = this.tryRecipes(itemStacksInGrid);
            if (recipe != null) {
                this.hasValidRecipe = true;
                this.lastValidRecipe = recipe;
                this.lastRecipeGrid = itemStacksInGrid;
                this.recipeOutput = this.lastValidRecipe.func_77571_b();
                this.shouldSearch = false;
                this.setPreviewSlot(previewHandler, this.lastValidRecipe.func_77571_b());
                this.timer = 40;
            } else {
                this.reset();
                this.shouldSearch = false;
            }
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        IEnergyStorage cap = (IEnergyStorage)this.energyCap.orElse(null);
        if (cap == null) {
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (cap.getEnergyStored() < cost && cost > 0) {
            return;
        }
        if (this.hasValidRecipe) {
            if (--this.timer > 0) {
                return;
            }
            this.timer = 40;
            if (this.doCraft((IItemHandler)this.inputHandler, true)) {
                ItemStack output = this.recipeOutput.func_77946_l();
                if (this.hasFreeSpace((IItemHandler)this.outHandler, this.recipeOutput) && this.doCraft((IItemHandler)this.inputHandler, false)) {
                    if (this.lastValidRecipe != null && this.lastValidRecipe instanceof ShapedRecipe) {
                        ShapedRecipe r = (ShapedRecipe)this.lastValidRecipe;
                        r.func_179532_b((IInventory)this.craftMatrix);
                    }
                    this.energy.extractEnergy(cost, false);
                    ArrayList<ItemStack> itemStacksInGridBackup = this.getItemsInCraftingGrid();
                    for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                        int j;
                        ItemStack result;
                        boolean leftoverEqual;
                        ItemStack recipeLeftover = this.craftMatrix.func_70301_a(i);
                        if (recipeLeftover.func_190926_b() || recipeLeftover.getContainerItem().func_190926_b()) continue;
                        ModCyclic.LOGGER.info(i + " recipe leftovers " + recipeLeftover + " ||| itemStacksInGridBackup " + itemStacksInGridBackup.get(i));
                        boolean bl = leftoverEqual = recipeLeftover.func_77973_b() == recipeLeftover.getContainerItem().func_77973_b();
                        if (leftoverEqual) {
                            ModCyclic.LOGGER.info(i + "leftoverEqual TRUE  " + recipeLeftover.getContainerItem());
                            result = recipeLeftover.getContainerItem().func_77946_l();
                            for (j = 0; j < this.inputHandler.getSlots() && !(result = this.inputHandler.insertItem(j, result, false)).func_190926_b(); ++j) {
                            }
                            continue;
                        }
                        result = recipeLeftover.getContainerItem().func_77946_l();
                        for (j = 0; j < this.outHandler.getSlots() && !(result = this.outHandler.insertItem(j, result, false)).func_190926_b(); ++j) {
                        }
                    }
                    for (int slotId = 0; slotId < 10 && (output = this.outHandler.insertItem(slotId, output, false)) != ItemStack.field_190927_a && output.func_190916_E() != 0; ++slotId) {
                    }
                    this.updateComparatorOutputLevel();
                }
            }
        }
    }

    private ArrayList<ItemStack> getItemsInCraftingGrid() {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        IItemHandler gridHandler = (IItemHandler)this.gridCap.orElse(null);
        if (gridHandler == null) {
            return null;
        }
        for (int i = 0; i < 9; ++i) {
            itemStacks.add(gridHandler.getStackInSlot(i));
        }
        return itemStacks;
    }

    private void setPreviewSlot(IItemHandler previewHandler, ItemStack itemStack) {
        previewHandler.extractItem(0, 64, false);
        previewHandler.insertItem(0, itemStack, false);
    }

    private boolean hasFreeSpace(IItemHandler inv, ItemStack output) {
        for (int slotId = 0; slotId < 10; ++slotId) {
            if (inv.getStackInSlot(slotId) == ItemStack.field_190927_a || inv.getStackInSlot(slotId).func_77969_a(output) && inv.getStackInSlot(slotId).func_190916_E() + output.func_190916_E() <= output.func_77976_d()) {
                return true;
            }
            if (output != ItemStack.field_190927_a && output.func_190916_E() != 0) continue;
            return true;
        }
        return false;
    }

    private boolean doCraft(IItemHandler input, boolean simulate) {
        HashMap<Integer, List<ItemStack>> putbackStacks = new HashMap<Integer, List<ItemStack>>();
        for (Ingredient ingredient : this.lastValidRecipe.func_192400_c()) {
            if (ingredient == Ingredient.field_193370_a) continue;
            boolean matched = false;
            for (int index = 0; index < input.getSlots(); ++index) {
                ItemStack itemStack = input.getStackInSlot(index);
                if (!ingredient.test(itemStack)) continue;
                if (putbackStacks.containsKey(index)) {
                    putbackStacks.get(index).add(new ItemStack((IItemProvider)input.getStackInSlot(index).func_77973_b(), 1));
                } else {
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                    list.add(new ItemStack((IItemProvider)input.getStackInSlot(index).func_77973_b(), 1));
                    putbackStacks.put(index, list);
                }
                matched = true;
                input.extractItem(index, 1, false);
                break;
            }
            if (matched) continue;
            this.putbackStacks(putbackStacks, input);
            return false;
        }
        if (simulate) {
            this.putbackStacks(putbackStacks, input);
        }
        return true;
    }

    private void putbackStacks(HashMap<Integer, List<ItemStack>> putbackStacks, IItemHandler itemHandler) {
        for (Map.Entry<Integer, List<ItemStack>> entry : putbackStacks.entrySet()) {
            for (ItemStack stack : entry.getValue()) {
                itemHandler.insertItem(entry.getKey().intValue(), stack, false);
            }
        }
    }

    private IRecipe<?> tryRecipes(ArrayList<ItemStack> itemStacksInGrid) {
        if (this.field_145850_b == null || this.field_145850_b.func_73046_m() == null) {
            return null;
        }
        Collection recipes = this.field_145850_b.func_73046_m().func_199529_aN().func_199510_b();
        for (IRecipe recipe : recipes) {
            ShapedRecipe shapedRecipe;
            if (recipe instanceof ShapelessRecipe) {
                ShapelessRecipe shapelessRecipe = (ShapelessRecipe)recipe;
                if (!this.tryMatchShapelessRecipe(itemStacksInGrid, shapelessRecipe)) continue;
                return shapelessRecipe;
            }
            if (!(recipe instanceof ShapedRecipe) || !this.doSizesMatch(shapedRecipe = (ShapedRecipe)recipe, itemStacksInGrid) || !this.tryMatchShapedRecipe(itemStacksInGrid, shapedRecipe)) continue;
            return shapedRecipe;
        }
        return null;
    }

    private boolean tryMatchShapedRecipe(ArrayList<ItemStack> itemStacks, ShapedRecipe recipe) {
        for (int i = 0; i <= 3 - recipe.func_192403_f(); ++i) {
            for (int j = 0; j <= 3 - recipe.func_192404_g(); ++j) {
                if (!this.tryMatchShapedRecipeRegion(itemStacks, recipe, i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean tryMatchShapelessRecipe(ArrayList<ItemStack> itemStacks, ShapelessRecipe recipe) {
        ArrayList itemStacksCopy = (ArrayList)itemStacks.clone();
        for (Ingredient ingredient : recipe.func_192400_c()) {
            Iterator iter = itemStacksCopy.iterator();
            boolean matched = false;
            while (iter.hasNext()) {
                ItemStack itemStack = (ItemStack)iter.next();
                if (!ingredient.test(itemStack)) continue;
                iter.remove();
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return this.countNonEmptyStacks(itemStacksCopy) == 0;
    }

    private boolean tryMatchShapedRecipeRegion(ArrayList<ItemStack> itemStacks, ShapedRecipe recipe, int offsetX, int offsetY) {
        for (int i = 0; i < recipe.func_192403_f(); ++i) {
            for (int j = 0; j < recipe.func_192404_g(); ++j) {
                try {
                    int indexInArray = i + j * 3;
                    ItemStack itemStack = itemStacks.get(indexInArray);
                    this.craftMatrix.func_70299_a(indexInArray, itemStack.func_77946_l());
                    continue;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        boolean matched = recipe.func_77569_a(this.craftMatrix, this.field_145850_b);
        return matched;
    }

    public void reset() {
        this.hasValidRecipe = false;
        this.lastRecipeGrid = null;
        this.lastValidRecipe = null;
        this.shouldSearch = true;
        this.timer = 0;
        IItemHandler previewHandler = (IItemHandler)this.preview.orElse(null);
        if (previewHandler != null) {
            this.setPreviewSlot(previewHandler, ItemStack.field_190927_a);
        }
    }

    private int countNonEmptyStacks(ArrayList<ItemStack> itemStacks) {
        int count = 0;
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == ItemStack.field_190927_a) continue;
            ++count;
        }
        return count;
    }

    private boolean doSizesMatch(ShapedRecipe recipe, ArrayList<ItemStack> itemStacks) {
        int ingredientCount = 0;
        int itemStackCount = 0;
        for (Ingredient ingredient : recipe.func_192400_c()) {
            if (ingredient.test(ItemStack.field_190927_a)) continue;
            ++ingredientCount;
        }
        for (ItemStack itemStack : itemStacks) {
            if (itemStack == ItemStack.field_190927_a) continue;
            ++itemStackCount;
        }
        return ingredientCount == itemStackCount;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCrafter(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, ItemHandlers type) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (type) {
                case INPUT: {
                    return this.input.cast();
                }
                case OUTPUT: {
                    return this.output.cast();
                }
                case GRID: {
                    return this.gridCap.cast();
                }
                case PREVIEW: {
                    return this.preview.cast();
                }
            }
        }
        return null;
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        this.input.invalidate();
        this.output.invalidate();
        this.gridCap.invalidate();
        this.preview.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.energyCap.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("energy")));
        this.input.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("input")));
        this.output.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("output")));
        this.gridCap.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("grid")));
        this.preview.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)tag.func_74775_l("preview")));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        this.energyCap.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("energy", (INBT)compound);
        });
        this.input.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("input", (INBT)compound);
        });
        this.output.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("output", (INBT)compound);
        });
        this.gridCap.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("grid", (INBT)compound);
        });
        this.preview.ifPresent(h -> {
            CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            tag.func_218657_a("preview", (INBT)compound);
        });
        return super.func_189515_b(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case TIMER: {
                return this.timer;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return -1;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case TIMER: {
                this.timer = value;
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    public static class FakeContainer
    extends Container {
        protected FakeContainer(ContainerType<?> type, int id) {
            super(type, id);
        }

        public boolean func_75145_c(PlayerEntity playerIn) {
            return true;
        }
    }

    public static enum ItemHandlers {
        INPUT,
        OUTPUT,
        GRID,
        PREVIEW;

    }

    public static enum Fields {
        TIMER,
        REDSTONE,
        RENDER;

    }
}

