/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.collectitem;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.collectitem.ContainerItemCollector;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemCollector
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    static final int MAX_SIZE = 12;
    static final int MAX_HEIGHT = 64;
    private int height = 1;
    private boolean directionIsUp = false;
    ItemStackHandler inventory = new ItemStackHandler(18);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.filter_data;
        }
    };
    private int radius = 8;

    public TileItemCollector() {
        super(TileRegistry.COLLECTOR_ITEM);
        this.needsRedstone = 0;
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        AxisAlignedBB aabb = this.getRange();
        List list = this.field_145850_b.func_175647_a(ItemEntity.class, aabb, entity -> entity.func_70089_S());
        if (list.size() > 0) {
            ItemEntity stackEntity = (ItemEntity)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
            ItemStack remainder = stackEntity.func_92059_d();
            if (!FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), remainder)) {
                return;
            }
            for (int i = 0; i < this.inventory.getSlots() && !remainder.func_190926_b(); ++i) {
                remainder = this.inventory.insertItem(i, remainder, false);
                this.updateComparatorOutputLevel();
            }
            stackEntity.func_92058_a(remainder);
            if (remainder.func_190926_b()) {
                stackEntity.func_70106_y();
            }
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerItemCollector(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.filter.deserializeNBT(tag.func_74775_l("filter"));
        this.radius = tag.func_74762_e("radius");
        this.height = tag.func_74762_e("height");
        this.directionIsUp = tag.func_74767_n("directionIsUp");
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        tag.func_74768_a("radius", this.radius);
        tag.func_74768_a("height", this.height);
        tag.func_74757_a("directionIsUp", this.directionIsUp);
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    private int heightWithDirection() {
        int diff;
        Direction blockFacing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        int n = diff = this.directionIsUp ? 1 : -1;
        if (blockFacing.func_176740_k().func_200128_b()) {
            diff = blockFacing == Direction.UP ? 1 : -1;
        }
        return diff * this.height;
    }

    public List<BlockPos> getShapeHollow() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List<BlockPos> shape = UtilShape.squareHorizontalHollow(center, this.radius);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = UtilShape.repeatShapeByHeight(shape, heightWithDirection);
        }
        return shape;
    }

    private AxisAlignedBB getRange() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        int heightWithDirection = this.heightWithDirection();
        AxisAlignedBB aabb = new AxisAlignedBB(center);
        aabb = aabb.func_72321_a(0.0, (double)heightWithDirection, 0.0);
        aabb = aabb.func_72314_b((double)this.radius, 0.0, (double)this.radius);
        return aabb;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 64);
                break;
            }
            case DIRECTION: {
                this.directionIsUp = value == 1;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case SIZE: {
                return this.radius;
            }
            case HEIGHT: {
                return this.height;
            }
            case DIRECTION: {
                return this.directionIsUp ? 1 : 0;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT,
        DIRECTION;

    }
}

