/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.collectfluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.collectfluid.ContainerFluidCollect;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilShape;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFluidCollect
extends TileEntityBase
implements ITickableTileEntity,
INamedContainerProvider {
    static final int MAX_HEIGHT = 64;
    public static final int MAX_SIZE = 12;
    public static final int CAPACITY = 64000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    FluidTankBase tank;
    private final LazyOptional<FluidTankBase> tankWrapper = LazyOptional.of(() -> this.tank);
    private int shapeIndex = 0;
    private int radius = 8;
    private int height = 4;
    BlockPos targetPos = null;
    static final int MAX = 64000;
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a;
        }
    };
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileFluidCollect() {
        super(TileRegistry.COLLECTOR_FLUID);
        this.tank = new FluidTankBase(this, 64000, p -> true);
    }

    public void func_73660_a() {
        FluidStack fstack;
        int result;
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        Integer cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        BlockState newState = Block.func_149634_a((Item)stack.func_77973_b()).func_176223_P();
        this.setLitProperty(true);
        List<BlockPos> shape = this.getShapeFilled();
        if (shape.size() == 0) {
            return;
        }
        this.incrementShapePtr(shape);
        this.targetPos = shape.get(this.shapeIndex);
        FluidState fluidState = this.field_145850_b.func_204610_c(this.targetPos);
        if (fluidState.func_206889_d() && (result = this.tank.fill(fstack = new FluidStack(fluidState.func_206886_c(), 1000), IFluidHandler.FluidAction.SIMULATE)) == 1000 && this.field_145850_b.func_175656_a(this.targetPos, newState)) {
            stack.func_190918_g(1);
            this.tank.fill(fstack, IFluidHandler.FluidAction.EXECUTE);
            this.energy.extractEnergy(cost, false);
        }
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    private int heightWithDirection() {
        Direction blockFacing = (Direction)this.func_195044_w().func_177229_b((Property)BlockStateProperties.field_208155_H);
        int diff = 1;
        if (blockFacing.func_176740_k().func_200128_b()) {
            diff = blockFacing == Direction.UP ? 1 : -1;
        }
        return diff * this.height;
    }

    public List<BlockPos> getShapeHollow() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        List<BlockPos> shape = UtilShape.squareHorizontalHollow(center, this.radius);
        int heightWithDirection = this.heightWithDirection();
        if (heightWithDirection != 0) {
            shape = UtilShape.repeatShapeByHeight(shape, heightWithDirection);
        }
        if (this.targetPos != null) {
            shape.add(this.targetPos);
        }
        return shape;
    }

    public List<BlockPos> getShapeFilled() {
        BlockPos center = this.getFacingShapeCenter(this.radius);
        int heightWithDirection = this.heightWithDirection();
        List<BlockPos> shape = UtilShape.squareHorizontalFull(center, this.radius);
        if (heightWithDirection != 0) {
            shape = UtilShape.repeatShapeByHeight(shape, heightWithDirection);
        }
        return shape;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerFluidCollect(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.tankWrapper.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        this.tankWrapper.invalidate();
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.shapeIndex = tag.func_74762_e("shapeIndex");
        this.tank.readFromNBT(tag.func_74775_l("fluid"));
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        CompoundNBT fluid = new CompoundNBT();
        this.tank.writeToNBT(fluid);
        tag.func_218657_a("fluid", (INBT)fluid);
        tag.func_74768_a("shapeIndex", this.shapeIndex);
        return super.func_189515_b(tag);
    }

    private void incrementShapePtr(List<BlockPos> shape) {
        ++this.shapeIndex;
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 64);
                break;
            }
            case SIZE: {
                this.radius = Math.min(value, 12);
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case HEIGHT: {
                return this.height;
            }
            case SIZE: {
                return this.radius;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT;

    }
}

