/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.item;

import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.TileCableBase;
import com.lothrazar.cyclic.block.cable.item.ContainerCableItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableItem
extends TileCableBase
implements ITickableTileEntity,
INamedContainerProvider {
    private static final int FLOW_QTY = 64;
    private int extractQty = 64;
    ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.filter_data;
        }
    };
    private final ConcurrentHashMap<Direction, LazyOptional<IItemHandler>> flow = new ConcurrentHashMap();

    public TileCableItem() {
        super(TileRegistry.item_pipeTile);
        for (Direction f : Direction.values()) {
            this.flow.put(f, (LazyOptional<IItemHandler>)LazyOptional.of(TileCableItem::createHandler));
        }
    }

    private static ItemStackHandler createHandler() {
        return new ItemStackHandler(1);
    }

    @Override
    public void updateConnection(Direction side, EnumConnectType connectType) {
        EnumConnectType oldConnectType = this.getConnectionType(side);
        if (connectType == EnumConnectType.BLOCKED && oldConnectType != EnumConnectType.BLOCKED) {
            LazyOptional<IItemHandler> sidedCap = this.flow.get(side);
            if (sidedCap != null) {
                sidedCap.invalidate();
            }
        } else if (oldConnectType == EnumConnectType.BLOCKED && connectType != EnumConnectType.BLOCKED) {
            this.flow.put(side, (LazyOptional<IItemHandler>)LazyOptional.of(TileCableItem::createHandler));
        }
        super.updateConnection(side, connectType);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (Direction extractSide : Direction.values()) {
            EnumConnectType connection = this.getConnectionType(extractSide);
            if (!connection.isExtraction()) continue;
            IItemHandler sideHandler = (IItemHandler)this.flow.get(extractSide).orElse(null);
            this.tryExtract(sideHandler, extractSide, this.extractQty, this.filter);
        }
        this.normalFlow();
    }

    private void normalFlow() {
        block0: for (Direction incomingSide : Direction.values()) {
            IItemHandler sideHandler = (IItemHandler)this.flow.get(incomingSide).orElse(null);
            for (Direction outgoingSide : UtilDirection.getAllInDifferentOrder()) {
                EnumConnectType outgoingConnection;
                if (outgoingSide == incomingSide || (outgoingConnection = this.getConnectionType(outgoingSide)).isExtraction() || outgoingConnection.isBlocked() || !this.moveItems(outgoingSide, 64, sideHandler)) continue;
                continue block0;
            }
            this.moveItems(incomingSide, 64, sideHandler);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && !CableBase.isCableBlocked(this.func_195044_w(), side)) {
            return this.flow.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (LazyOptional<IItemHandler> sidedCap : this.flow.values()) {
            sidedCap.invalidate();
        }
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.extractQty = tag.func_74762_e("extractCount");
        this.filter.deserializeNBT(tag.func_74775_l("filter"));
        for (Direction f : Direction.values()) {
            LazyOptional<IItemHandler> item = this.flow.get(f);
            item.ifPresent(h -> {
                CompoundNBT itemTag = tag.func_74775_l("item" + f.toString());
                ((INBTSerializable)h).deserializeNBT((INBT)itemTag);
            });
        }
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        tag.func_74768_a("extractCount", this.extractQty);
        for (Direction f : Direction.values()) {
            LazyOptional<IItemHandler> item = this.flow.get(f);
            item.ifPresent(h -> {
                CompoundNBT compound = (CompoundNBT)((INBTSerializable)h).serializeNBT();
                tag.func_218657_a("item" + f.toString(), (INBT)compound);
            });
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
        this.extractQty = value;
    }

    @Override
    public int getField(int field) {
        return this.extractQty;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCableItem(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

