/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.lothrazar.cyclic.base.FluidTankBase;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.TileCableBase;
import com.lothrazar.cyclic.block.cable.fluid.ContainerCableFluid;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilDirection;
import com.lothrazar.cyclic.util.UtilFluid;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.EnumProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableFluid
extends TileCableBase
implements ITickableTileEntity,
INamedContainerProvider {
    final ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.filter_data;
        }
    };
    public static ForgeConfigSpec.IntValue BUFFERSIZE;
    public static ForgeConfigSpec.IntValue TRANSFER_RATE;
    private final FluidTank fluidTank;
    private final LazyOptional<IFluidHandler> fluidCap;
    private final ConcurrentHashMap<Direction, LazyOptional<IFluidHandler>> flow = new ConcurrentHashMap();

    public TileCableFluid() {
        super(TileRegistry.fluid_pipeTile);
        this.fluidTank = new FluidTankBase(this, (Integer)BUFFERSIZE.get() * 1000, fluidStack -> FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), fluidStack));
        this.fluidCap = LazyOptional.of(() -> this.fluidTank);
    }

    @Override
    public void updateConnection(Direction side, EnumConnectType connectType) {
        EnumProperty<EnumConnectType> property = CableBase.FACING_TO_PROPERTY_MAP.get(side);
        EnumConnectType oldConnectType = (EnumConnectType)((Object)this.func_195044_w().func_177229_b(property));
        if (connectType == EnumConnectType.BLOCKED && oldConnectType != EnumConnectType.BLOCKED) {
            this.flow.computeIfPresent(side, (k, v) -> {
                v.invalidate();
                return null;
            });
        } else if (oldConnectType == EnumConnectType.BLOCKED && connectType != EnumConnectType.BLOCKED) {
            this.flow.put(side, (LazyOptional<IFluidHandler>)LazyOptional.of(() -> this.fluidTank));
        }
        super.updateConnection(side, connectType);
    }

    public void func_73660_a() {
        for (Direction extractSide : Direction.values()) {
            EnumConnectType connection = this.getConnectionType(extractSide);
            if (!connection.isExtraction()) continue;
            this.tryExtract(extractSide);
        }
        this.normalFlow();
    }

    private void tryExtract(Direction extractSide) {
        Direction incomingSide;
        if (extractSide == null) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(extractSide);
        IFluidHandler tankTarget = UtilFluid.getTank(this.field_145850_b, target, incomingSide = extractSide.func_176734_d());
        if (tankTarget != null && tankTarget.getTanks() > 0 && !FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), tankTarget.getFluidInTank(0))) {
            return;
        }
        if (UtilFluid.tryFillPositionFromTank(this.field_145850_b, this.field_174879_c, extractSide, tankTarget, (Integer)TRANSFER_RATE.get())) {
            return;
        }
        if (!this.flow.containsKey(extractSide)) {
            LazyOptional hax = LazyOptional.of(() -> this.fluidTank);
            this.flow.put(extractSide, (LazyOptional<IFluidHandler>)hax);
        }
        IFluidHandler tank = (IFluidHandler)this.flow.get(extractSide).orElse(null);
        if (this.fluidTank.getSpace() > -1000) {
            UtilFluid.extractSourceWaterloggedCauldron(this.field_145850_b, target, tank);
        }
    }

    private void normalFlow() {
        for (Direction outgoingSide : UtilDirection.getAllInDifferentOrder()) {
            EnumConnectType connection = this.getConnectionType(outgoingSide);
            if (connection.isExtraction() || connection.isBlocked()) continue;
            this.moveFluids(outgoingSide, this.field_174879_c.func_177972_a(outgoingSide), (Integer)TRANSFER_RATE.get(), (IFluidHandler)this.fluidTank);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.fluidCap.cast();
            }
            LazyOptional sidedCap = this.flow.get(side);
            if (sidedCap == null) {
                if (this.getConnectionType(side) != EnumConnectType.BLOCKED) {
                    sidedCap = LazyOptional.of(() -> this.fluidTank);
                    this.flow.put(side, (LazyOptional<IFluidHandler>)sidedCap);
                    return sidedCap.cast();
                }
            } else {
                return sidedCap.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        for (LazyOptional<IFluidHandler> sidedCap : this.flow.values()) {
            sidedCap.invalidate();
        }
        super.invalidateCaps();
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.filter.deserializeNBT(tag.func_74775_l("filter"));
        this.fluidTank.readFromNBT(tag.func_74775_l("fluid"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("filter", (INBT)this.filter.serializeNBT());
        tag.func_218657_a("fluid", (INBT)this.fluidTank.writeToNBT(new CompoundNBT()));
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerCableFluid(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }
}

