/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.energy;

import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.ShapeCache;
import com.lothrazar.cyclic.block.cable.energy.TileCableEnergy;
import com.lothrazar.cyclic.config.ConfigRegistry;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockCableEnergy
extends CableBase {
    public BlockCableEnergy(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(0.5f));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        int st;
        TileEntity ent;
        IEnergyStorage handlerHere;
        if (world.field_72995_K && (handlerHere = (IEnergyStorage)(ent = world.func_175625_s(pos)).getCapability(CapabilityEnergy.ENERGY, null).orElse(null)) != null && (st = handlerHere.getEnergyStored()) > 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(st + ""), true);
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape facade;
        if (((Boolean)ConfigRegistry.CABLE_FACADES.get()).booleanValue() && (facade = this.getFacadeShape(state, worldIn, pos, context)) != null) {
            return facade;
        }
        return ShapeCache.getOrCreate(state, CableBase::createShape);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCableEnergy();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState stateIn, LivingEntity placer, ItemStack stack) {
        for (Direction d : Direction.values()) {
            IEnergyStorage energy;
            TileEntity facingTile = worldIn.func_175625_s(pos.func_177972_a(d));
            IEnergyStorage iEnergyStorage = energy = facingTile == null ? null : (IEnergyStorage)facingTile.getCapability(CapabilityEnergy.ENERGY, d.func_176734_d()).orElse(null);
            if (energy == null || !worldIn.func_175656_a(pos, stateIn = (BlockState)stateIn.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)((Object)EnumConnectType.INVENTORY)))) continue;
            this.updateConnection((IWorld)worldIn, pos, d, EnumConnectType.INVENTORY);
        }
        super.func_180633_a(worldIn, pos, stateIn, placer, stack);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        EnumProperty property = (EnumProperty)FACING_TO_PROPERTY_MAP.get(facing);
        EnumConnectType oldProp = (EnumConnectType)((Object)stateIn.func_177229_b((Property)property));
        if (oldProp.isBlocked() || oldProp.isExtraction()) {
            this.updateConnection(world, currentPos, facing, oldProp);
            return stateIn;
        }
        if (BlockCableEnergy.isEnergy(stateIn, facing, facingState, world, currentPos, facingPos)) {
            BlockState with = (BlockState)stateIn.func_206870_a((Property)property, (Comparable)((Object)EnumConnectType.INVENTORY));
            if (world instanceof World && world.func_180495_p(currentPos).func_177230_c() == this && ((World)world).func_175656_a(currentPos, with)) {
                this.updateConnection(world, currentPos, facing, EnumConnectType.INVENTORY);
            }
            return with;
        }
        this.updateConnection(world, currentPos, facing, EnumConnectType.NONE);
        return (BlockState)stateIn.func_206870_a((Property)property, (Comparable)((Object)EnumConnectType.NONE));
    }
}

