/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.breaker;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.breaker.ContainerBreaker;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.item.datacard.BlockStateMatcher;
import com.lothrazar.cyclic.item.datacard.BlockstateCard;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileBreaker
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    static final int MAX = 64000;
    public static final int TIMER_FULL = 500;
    ItemStackHandler inventory = new ItemStackHandler(){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.func_77973_b() == ItemRegistry.STATECARD.get();
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileBreaker() {
        super(TileRegistry.breakerTile);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos target = this.field_174879_c.func_177972_a(this.getCurrentFacing());
        if (this.isTargetValid(target)) {
            this.field_145850_b.func_175655_b(target, true);
        }
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    private boolean isTargetValid(BlockPos targetPos) {
        World level = this.field_145850_b;
        BlockState targetState = level.func_180495_p(targetPos);
        if (targetState.func_177230_c() == Blocks.field_150350_a) {
            return false;
        }
        if (targetState.func_185887_b((IBlockReader)level, targetPos) < 0.0f) {
            return false;
        }
        if (targetState.func_235714_a_(DataTags.BREAKER_IGNORED)) {
            ModCyclic.LOGGER.info("breaker/ignored tag skips " + targetPos);
            return false;
        }
        if (targetState.func_204520_s() != null && !targetState.func_204520_s().func_206888_e() && !targetState.func_235901_b_((Property)BlockStateProperties.field_208198_y)) {
            return false;
        }
        return this.isValidFromDatacard(targetState);
    }

    private boolean isValidFromDatacard(BlockState targetState) {
        ItemStack filter = this.inventory.getStackInSlot(0);
        if (filter.func_190926_b()) {
            return true;
        }
        for (BlockStateMatcher m : BlockstateCard.getSavedStates(filter)) {
            if (!m.doesMatch(targetState)) continue;
            return true;
        }
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerBreaker(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        return super.func_189515_b(tag);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    public int getEnergyMax() {
        return 64000;
    }

    static enum Fields {
        REDSTONE,
        TIMER;

    }
}

