/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.apple;

import com.lothrazar.cyclic.base.BlockBase;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;

public class AppleCropBlock
extends BlockBase
implements IGrowable {
    private static final int MAX_AGE = 7;
    private static final IntegerProperty AGE = BlockStateProperties.field_208170_W;
    private static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)12.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)11.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)10.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)9.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)6.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0), Block.func_208617_a((double)4.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)12.0)};
    boolean canBonemeal = true;

    public AppleCropBlock(AbstractBlock.Properties builder, boolean canBonemeal) {
        super(builder.func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_222472_s));
        this.canBonemeal = canBonemeal;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    @Override
    public void registerClient() {
        RenderTypeLookup.setRenderLayer((Block)this, (RenderType)RenderType.func_228641_d_());
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, IBlockDisplayReader world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return this.canBonemeal;
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) < 7;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177984_a()).func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        int age = (Integer)state.func_177229_b((Property)AGE);
        if (age < 7 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (worldIn.field_73012_v.nextInt(5) == 0 ? 1 : 0) != 0)) {
            this.func_225535_a_(worldIn, random, pos, state);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)AGE) < 7;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)AGE)];
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)AGE) + 1)), 2);
    }
}

