/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.base;

import com.lothrazar.cyclic.config.ClientConfigCyclic;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.util.UtilSound;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockBase
extends Block {
    public static final BooleanProperty LIT = BooleanProperty.func_177716_a((String)"lit");
    private boolean hasGui = false;
    private boolean hasFluidInteract = false;

    public BlockBase(AbstractBlock.Properties properties) {
        super(properties);
        BlockRegistry.blocksClientRegistry.add(this);
    }

    protected BlockBase setHasGui() {
        this.hasGui = true;
        return this;
    }

    protected BlockBase setHasFluidInteract() {
        this.hasFluidInteract = true;
        return this;
    }

    public BlockState rotate(BlockState state, IWorld world, BlockPos pos, Rotation direction) {
        Direction oldDir;
        Direction newDir;
        if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J) && (newDir = direction.func_185831_a(oldDir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J))) != Direction.UP && newDir != Direction.DOWN) {
            return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)newDir);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
            oldDir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
            newDir = direction.func_185831_a(oldDir);
            return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)newDir);
        }
        BlockState newState = state.func_185907_a(direction);
        return newState;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (this.hasFluidInteract) {
            IFluidHandler handler;
            TileEntity tankHere;
            if (!world.field_72995_K && (tankHere = world.func_175625_s(pos)) != null && (handler = (IFluidHandler)tankHere.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, hit.func_216354_b()).orElse(null)) != null) {
                if (FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)hand, (IFluidHandler)handler)) {
                    if (handler.getFluidInTank(0) != null) {
                        this.displayClientFluidMessage(player, handler);
                    }
                    if (player instanceof ServerPlayerEntity) {
                        UtilSound.playSoundFromServer((ServerPlayerEntity)player, SoundEvents.field_187630_M);
                    }
                } else {
                    this.displayClientFluidMessage(player, handler);
                }
            }
            if (FluidUtil.getFluidHandler((ItemStack)player.func_184586_b(hand)).isPresent()) {
                return ActionResultType.SUCCESS;
            }
        }
        if (this.hasGui) {
            if (!world.field_72995_K) {
                TileEntity tileEntity = world.func_175625_s(pos);
                if (tileEntity instanceof INamedContainerProvider) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
                } else {
                    throw new IllegalStateException("Our named container provider is missing!");
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    private void displayClientFluidMessage(PlayerEntity player, IFluidHandler handler) {
        if (((Boolean)ClientConfigCyclic.FLUID_BLOCK_STATUS.get()).booleanValue()) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(BlockBase.getFluidRatioName(handler)), true);
        }
    }

    public static String getFluidRatioName(IFluidHandler handler) {
        String ratio = handler.getFluidInTank(0).getAmount() + "/" + handler.getTankCapacity(0);
        if (!handler.getFluidInTank(0).isEmpty()) {
            ratio = ratio + " " + handler.getFluidInTank(0).getDisplayName().getString();
        }
        return ratio;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            IItemHandler items;
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity != null && (items = (IItemHandler)tileentity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null)) != null) {
                for (int i = 0; i < items.getSlots(); ++i) {
                    InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)items.getStackInSlot(i));
                }
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_149739_a() + ".tooltip").func_240699_a_(TextFormatting.GRAY));
    }

    public void registerClient() {
    }

    public static boolean isItem(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return BlockBase.hasCapabilityDir(facing, world, facingPos, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public static boolean isFluid(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return BlockBase.hasCapabilityDir(facing, world, facingPos, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
    }

    public static boolean isEnergy(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        return BlockBase.hasCapabilityDir(facing, world, facingPos, CapabilityEnergy.ENERGY);
    }

    private static boolean hasCapabilityDir(Direction facing, IWorld world, BlockPos facingPos, Capability<?> cap) {
        if (facing == null) {
            return false;
        }
        TileEntity neighbor = world.func_175625_s(facingPos);
        return neighbor != null && neighbor.getCapability(cap, facing.func_176734_d()).orElse(null) != null;
    }

    protected int calcRedstoneFromFluid(TileEntity tileEntity) {
        IFluidHandler fluid = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
        if (fluid.getFluidInTank(0).isEmpty()) {
            return 0;
        }
        float cap = fluid.getTankCapacity(0);
        float amt = fluid.getFluidInTank(0).getAmount();
        float f = amt / cap;
        return MathHelper.func_76141_d((float)(f * 14.0f)) + 1;
    }
}

