/*
 * Decompiled with CFR 0.152.
 */
package com.mcwdoors.kikoz.objects;

import com.mcwdoors.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GarageDoor
extends Block {
    public static final EnumProperty<GaragePart> PART = EnumProperty.func_177709_a((String)"part", GaragePart.class);
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final VoxelShape EAST = Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH = Block.func_208617_a((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        if (facing == Direction.WEST || facing == Direction.EAST) {
            return NORTH;
        }
        return EAST;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue()) {
            return VoxelShapes.func_197880_a();
        }
        return state.func_177229_b((Property)FACING) == Direction.WEST || state.func_177229_b((Property)FACING) == Direction.EAST ? NORTH : EAST;
    }

    public GarageDoor(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    protected BlockState GarageState(BlockState state, IWorld level, BlockPos pos) {
        boolean below;
        boolean above = level.func_180495_p(pos.func_177984_a()).func_177230_c() == this;
        boolean bl = below = level.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        if (above && below) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.MIDDLE));
        }
        if (!above && below) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        return (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP));
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.func_203425_a(state.func_177230_c())) {
            this.GarageState(state, (IWorld)level, pos);
        }
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.GarageState(super.func_196258_a(context), (IWorld)context.func_195991_k(), context.func_195995_a()).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176746_e());
    }

    public void placeAt(World level, BlockPos pos, int num) {
        level.func_180501_a(pos, this.func_176223_P(), num);
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState newState, IWorld level, BlockPos pos, BlockPos newPos) {
        return this.GarageState(state, level, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, FACING, POWERED, OPEN});
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.func_177229_b((Property)OPEN);
    }

    public void openDoor(World level, BlockState state, BlockPos pos, boolean open) {
        if (state.func_203425_a((Block)this) && (Boolean)state.func_177229_b((Property)OPEN) != open) {
            level.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == this.func_199767_j()) {
            return ActionResultType.PASS;
        }
        this.garageDoor(level, pos, (Boolean)state.func_177229_b((Property)OPEN) == false, (Direction)state.func_177229_b((Property)FACING));
        level.func_184133_a(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
        state = (BlockState)state.func_235896_a_((Property)OPEN);
        level.func_180501_a(pos, state, 10);
        return ActionResultType.SUCCESS;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, World level, BlockPos currentPos, BlockPos facingPos) {
        return super.func_196271_a(stateIn, facing, facingState, (IWorld)level, currentPos, facingPos);
    }

    public void func_176208_a(World level, BlockPos pos, BlockState state, PlayerEntity player) {
        Block block = level.func_180495_p(pos).func_177230_c();
        Block upper = level.func_180495_p(pos.func_177981_b(1)).func_177230_c();
        Block lower = level.func_180495_p(pos.func_177979_c(1)).func_177230_c();
        if (upper == block && lower == block) {
            level.func_175656_a(pos.func_177979_c(1), (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP)));
        } else if (lower == block) {
            level.func_175656_a(pos.func_177979_c(1), (BlockState)state.func_206870_a(PART, (Comparable)((Object)GaragePart.TOP)));
        }
        level.func_184133_a(null, pos, SoundEvents.field_187766_dk, SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
        if (((Boolean)state.func_177229_b((Property)OPEN)).booleanValue() && state.func_177229_b(PART) == GaragePart.BOTTOM || state.func_177229_b(PART) == GaragePart.MIDDLE) {
            // empty if block
        }
    }

    private void garageDoor(World level, BlockPos pos, boolean bool, Direction dir) {
        BlockState state = level.func_180495_p(pos);
        if (state.func_177230_c() == this && (Boolean)state.func_177229_b((Property)OPEN) != bool && ((Direction)state.func_177229_b((Property)FACING)).equals((Object)dir)) {
            level.func_175656_a(pos, (BlockState)state.func_206870_a((Property)OPEN, (Comparable)Boolean.valueOf(bool)));
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos newPos = pos.func_177982_a(x, y, z);
                        this.garageDoor(level, newPos, bool, dir);
                    }
                }
            }
        }
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block block, BlockPos neighborPos, boolean isMoving) {
        if (!level.field_72995_K) {
            boolean powered;
            boolean bl = powered = level.func_175640_z(pos) || level.func_175640_z(pos.func_177984_a());
            if ((Boolean)state.func_177229_b((Property)POWERED) != powered) {
                level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
                if ((Boolean)state.func_177229_b((Property)OPEN) != powered) {
                    this.garageDoor(level, pos, (Boolean)state.func_177229_b((Property)OPEN) == false, (Direction)state.func_177229_b((Property)FACING));
                    level.func_184133_a(null, pos, (SoundEvent)SoundsInit.GARAGE.get(), SoundCategory.BLOCKS, 0.5f, level.field_73012_v.nextFloat() * 0.1f + 0.8f);
                }
            }
        }
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType pathtype) {
        return false;
    }

    public static enum GaragePart implements IStringSerializable
    {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

