/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.AlexsMobs;
import com.github.alexthe666.alexsmobs.entity.EntityGorilla;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.vector.Vector3d;

public class GorillaAIFollowCaravan
extends Goal {
    public final EntityGorilla gorilla;
    private double speedModifier;
    private int distCheckCounter;

    public GorillaAIFollowCaravan(EntityGorilla llamaIn, double speedModifierIn) {
        this.gorilla = llamaIn;
        this.speedModifier = speedModifierIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!(this.gorilla.isSilverback() || this.gorilla.inCaravan() || this.gorilla.isSitting())) {
            double dist = 15.0;
            List list = this.gorilla.field_70170_p.func_217357_a(EntityGorilla.class, this.gorilla.func_174813_aQ().func_72314_b(dist, dist / 2.0, dist));
            EntityGorilla gorilla = null;
            double d0 = Double.MAX_VALUE;
            for (Entity entity : list) {
                double d1;
                EntityGorilla gorilla1 = (EntityGorilla)entity;
                if (!gorilla1.inCaravan() || gorilla1.hasCaravanTrail() || (d1 = this.gorilla.func_70068_e((Entity)gorilla1)) > d0) continue;
                d0 = d1;
                gorilla = gorilla1;
            }
            if (gorilla == null) {
                for (Entity entity1 : list) {
                    double d2;
                    EntityGorilla llamaentity2 = (EntityGorilla)entity1;
                    if (!llamaentity2.isSilverback() || llamaentity2.hasCaravanTrail() || (d2 = this.gorilla.func_70068_e((Entity)llamaentity2)) > d0) continue;
                    d0 = d2;
                    gorilla = llamaentity2;
                }
            }
            if (gorilla == null) {
                return false;
            }
            if (d0 < 2.0) {
                return false;
            }
            if (!gorilla.isSilverback() && !this.firstIsSilverback(gorilla, 1)) {
                return false;
            }
            this.gorilla.joinCaravan(gorilla);
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.gorilla.isSitting()) {
            return false;
        }
        if (this.gorilla.inCaravan() && this.gorilla.getCaravanHead().func_70089_S() && this.firstIsSilverback(this.gorilla, 0)) {
            double d0 = this.gorilla.func_70068_e((Entity)this.gorilla.getCaravanHead());
            if (d0 > 676.0) {
                if (this.speedModifier <= 1.5) {
                    this.speedModifier *= 1.2;
                    this.distCheckCounter = 40;
                    return true;
                }
                if (this.distCheckCounter == 0) {
                    return false;
                }
            }
            if (this.distCheckCounter > 0) {
                --this.distCheckCounter;
            }
            return true;
        }
        return false;
    }

    public void func_75251_c() {
        this.gorilla.leaveCaravan();
        this.speedModifier = 1.5;
    }

    public void func_75246_d() {
        EntityGorilla llamaentity;
        if (this.gorilla.inCaravan() && !this.gorilla.isSitting() && (llamaentity = this.gorilla.getCaravanHead()) != null) {
            double d0 = this.gorilla.func_70032_d((Entity)llamaentity);
            Vector3d vector3d = new Vector3d(llamaentity.func_226277_ct_() - this.gorilla.func_226277_ct_(), llamaentity.func_226278_cu_() - this.gorilla.func_226278_cu_(), llamaentity.func_226281_cx_() - this.gorilla.func_226281_cx_()).func_72432_b().func_186678_a(Math.max(d0 - 2.0, 0.0));
            if (this.gorilla.func_70661_as().func_75500_f()) {
                try {
                    this.gorilla.func_70661_as().func_75492_a(this.gorilla.func_226277_ct_() + vector3d.field_72450_a, this.gorilla.func_226278_cu_() + vector3d.field_72448_b, this.gorilla.func_226281_cx_() + vector3d.field_72449_c, this.speedModifier);
                }
                catch (NullPointerException e) {
                    AlexsMobs.LOGGER.warn("gorilla encountered issue following caravan head");
                }
            }
        }
    }

    private boolean firstIsSilverback(EntityGorilla llama, int p_190858_2_) {
        if (p_190858_2_ > 8) {
            return false;
        }
        if (llama.inCaravan()) {
            if (llama.getCaravanHead().isSilverback()) {
                return true;
            }
            EntityGorilla llamaentity = llama.getCaravanHead();
            return this.firstIsSilverback(llamaentity, ++p_190858_2_);
        }
        return false;
    }
}

