/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class CreatureAITargetItems<T extends ItemEntity>
extends TargetGoal {
    protected final Sorter theNearestAttackableTargetSorter;
    protected final Predicate<? super ItemEntity> targetEntitySelector;
    protected int executionChance;
    protected boolean mustUpdate;
    protected ItemEntity targetEntity;
    private ITargetsDroppedItems hunter;
    private int tickThreshold;
    private float radius = 9.0f;
    private int walkCooldown = 0;

    public CreatureAITargetItems(CreatureEntity creature, boolean checkSight) {
        this(creature, checkSight, false);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public CreatureAITargetItems(CreatureEntity creature, boolean checkSight, int tickThreshold) {
        this(creature, checkSight, false, tickThreshold, 9);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public CreatureAITargetItems(CreatureEntity creature, boolean checkSight, boolean onlyNearby) {
        this(creature, 10, checkSight, onlyNearby, null, 0);
    }

    public CreatureAITargetItems(CreatureEntity creature, boolean checkSight, boolean onlyNearby, int tickThreshold, int radius) {
        this(creature, 10, checkSight, onlyNearby, null, tickThreshold);
        this.radius = radius;
    }

    public CreatureAITargetItems(CreatureEntity creature, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector, int ticksExisted) {
        super((MobEntity)creature, checkSight, onlyNearby);
        this.executionChance = chance;
        this.tickThreshold = ticksExisted;
        this.hunter = (ITargetsDroppedItems)creature;
        this.theNearestAttackableTargetSorter = new Sorter((Entity)creature);
        this.targetEntitySelector = new Predicate<ItemEntity>(){

            public boolean apply(@Nullable ItemEntity item) {
                ItemStack stack = item.func_92059_d();
                return !stack.func_190926_b() && CreatureAITargetItems.this.hunter.canTargetItem(stack) && item.field_70173_aa > CreatureAITargetItems.this.tickThreshold;
            }
        };
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        List list;
        if (this.field_75299_d.func_184218_aH() || this.field_75299_d.func_184207_aI() && this.field_75299_d.func_184179_bs() != null) {
            return false;
        }
        if (!this.field_75299_d.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            return false;
        }
        if (!this.mustUpdate) {
            long worldTime = this.field_75299_d.field_70170_p.func_82737_E() % 10L;
            if (this.field_75299_d.func_70654_ax() >= 100 && worldTime != 0L) {
                return false;
            }
            if (this.field_75299_d.func_70681_au().nextInt(this.executionChance) != 0 && worldTime != 0L) {
                return false;
            }
        }
        if ((list = this.field_75299_d.field_70170_p.func_175647_a(ItemEntity.class, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector)).isEmpty()) {
            return false;
        }
        Collections.sort(list, this.theNearestAttackableTargetSorter);
        this.targetEntity = (ItemEntity)list.get(0);
        this.mustUpdate = false;
        this.hunter.onFindTarget(this.targetEntity);
        return true;
    }

    protected double func_111175_f() {
        return 16.0;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        Vector3d renderCenter = new Vector3d(this.field_75299_d.func_226277_ct_() + 0.5, this.field_75299_d.func_226278_cu_() + 0.5, this.field_75299_d.func_226281_cx_() + 0.5);
        AxisAlignedBB aabb = new AxisAlignedBB((double)(-this.radius), (double)(-this.radius), (double)(-this.radius), (double)this.radius, (double)this.radius, (double)this.radius);
        return aabb.func_191194_a(renderCenter);
    }

    public void func_75249_e() {
        this.moveTo();
        super.func_75249_e();
    }

    protected void moveTo() {
        if (this.walkCooldown > 0) {
            --this.walkCooldown;
        } else {
            this.field_75299_d.func_70661_as().func_75492_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
            this.walkCooldown = 30 + this.field_75299_d.func_70681_au().nextInt(40);
        }
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.field_75299_d.func_70661_as().func_75499_g();
        this.targetEntity = null;
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.targetEntity == null || this.targetEntity != null && !this.targetEntity.func_70089_S()) {
            this.func_75251_c();
            this.field_75299_d.func_70661_as().func_75499_g();
        } else {
            this.moveTo();
        }
        if (this.targetEntity != null && this.field_75299_d.func_70685_l((Entity)this.targetEntity) && (double)this.field_75299_d.func_213311_cf() > 2.0 && this.field_75299_d.func_233570_aj_()) {
            this.field_75299_d.func_70605_aq().func_75642_a(this.targetEntity.func_226277_ct_(), this.targetEntity.func_226278_cu_(), this.targetEntity.func_226281_cx_(), 1.0);
        }
        if (this.targetEntity != null && this.targetEntity.func_70089_S() && this.field_75299_d.func_70068_e((Entity)this.targetEntity) < this.hunter.getMaxDistToItem() && this.field_75299_d.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
            this.hunter.onGetItem(this.targetEntity);
            this.targetEntity.func_92059_d().func_190918_g(1);
            this.func_75251_c();
        }
    }

    public void makeUpdate() {
        this.mustUpdate = true;
    }

    public boolean func_75253_b() {
        boolean path = (double)this.field_75299_d.func_213311_cf() > 2.0 || !this.field_75299_d.func_70661_as().func_75500_f();
        return path && this.targetEntity != null && this.targetEntity.func_70089_S();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity theEntity;

        public Sorter(Entity theEntityIn) {
            this.theEntity = theEntityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.theEntity.func_70068_e(p_compare_1_);
            return d0 < (d1 = this.theEntity.func_70068_e(p_compare_2_)) ? -1 : (d0 > d1 ? 1 : 0);
        }
    }
}

