/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityCapuchinMonkey;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class CapuchinAITargetBalloons
extends Goal {
    private EntityCapuchinMonkey monkey;
    protected final boolean shouldCheckSight;
    private final boolean nearbyOnly;
    private int targetSearchStatus;
    private int targetSearchDelay;
    private int targetUnseenTicks;
    protected Entity target;
    protected int unseenMemoryTicks = 60;
    protected final int targetChance;
    public static final Predicate<Entity> TARGET_BLOON = balloon -> balloon.func_70022_Q() != null && (balloon.func_70022_Q().contains("balloon") || balloon.func_70022_Q().contains("balloom"));

    public CapuchinAITargetBalloons(EntityCapuchinMonkey mobIn, boolean checkSight) {
        this(mobIn, checkSight, false, 40);
    }

    public CapuchinAITargetBalloons(EntityCapuchinMonkey mobIn, boolean checkSight, boolean nearbyOnlyIn, int targetChance) {
        this.func_220684_a(EnumSet.of(Goal.Flag.TARGET));
        this.monkey = mobIn;
        this.shouldCheckSight = checkSight;
        this.nearbyOnly = nearbyOnlyIn;
        this.targetChance = targetChance;
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.monkey.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        this.findNearestTarget();
        return this.target != null;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.monkey.func_174813_aQ().func_72314_b(targetDistance, targetDistance, targetDistance);
    }

    protected void findNearestTarget() {
        Entity closest = null;
        for (Entity bloon : this.monkey.field_70170_p.func_175647_a(Entity.class, this.getTargetableArea(this.getTargetDistance()), TARGET_BLOON)) {
            if (closest != null && !(closest.func_70032_d((Entity)this.monkey) > bloon.func_70032_d((Entity)this.monkey))) continue;
            closest = bloon;
        }
        this.target = closest;
    }

    public boolean func_75253_b() {
        Entity livingentity = this.monkey.getDartTarget();
        if (livingentity == null) {
            livingentity = this.target;
        }
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.func_70089_S()) {
            return false;
        }
        Team team = this.monkey.func_96124_cp();
        Team team1 = livingentity.func_96124_cp();
        if (team != null && team1 == team) {
            return false;
        }
        double d0 = this.getTargetDistance();
        if (this.monkey.func_70068_e(livingentity) > d0 * d0) {
            return false;
        }
        if (this.shouldCheckSight) {
            if (this.monkey.func_70635_at().func_75522_a(livingentity)) {
                this.targetUnseenTicks = 0;
            } else if (++this.targetUnseenTicks > this.unseenMemoryTicks) {
                return false;
            }
        }
        if (livingentity instanceof PlayerEntity && ((PlayerEntity)livingentity).field_71075_bZ.field_75102_a) {
            return false;
        }
        this.monkey.setDartTarget(livingentity);
        return true;
    }

    protected double getTargetDistance() {
        return this.monkey.func_233637_b_(Attributes.field_233819_b_);
    }

    public void func_75249_e() {
        this.monkey.setDartTarget(this.target);
        this.targetSearchStatus = 0;
        this.targetSearchDelay = 0;
        this.targetUnseenTicks = 0;
    }

    public void func_75251_c() {
        this.monkey.func_70624_b(null);
        this.monkey.setDartTarget(null);
        this.target = null;
    }

    protected boolean isSuitableTarget(@Nullable LivingEntity potentialTarget, EntityPredicate targetPredicate) {
        if (potentialTarget == null) {
            return false;
        }
        if (!targetPredicate.func_221015_a((LivingEntity)this.monkey, potentialTarget)) {
            return false;
        }
        if (!this.monkey.func_213389_a(potentialTarget.func_233580_cy_())) {
            return false;
        }
        if (this.nearbyOnly) {
            if (--this.targetSearchDelay <= 0) {
                this.targetSearchStatus = 0;
            }
            if (this.targetSearchStatus == 0) {
                int n = this.targetSearchStatus = this.canEasilyReach(potentialTarget) ? 1 : 2;
            }
            if (this.targetSearchStatus == 2) {
                return false;
            }
        }
        return true;
    }

    private boolean canEasilyReach(LivingEntity target) {
        int j;
        this.targetSearchDelay = 10 + this.monkey.func_70681_au().nextInt(5);
        Path path = this.monkey.func_70661_as().func_75494_a((Entity)target, 0);
        if (path == null) {
            return false;
        }
        PathPoint pathpoint = path.func_75870_c();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.field_75839_a - MathHelper.func_76128_c((double)target.func_226277_ct_());
        return (double)(i * i + (j = pathpoint.field_75838_c - MathHelper.func_76128_c((double)target.func_226281_cx_())) * j) <= 2.25;
    }

    public CapuchinAITargetBalloons setUnseenMemoryTicks(int unseenMemoryTicksIn) {
        this.unseenMemoryTicks = unseenMemoryTicksIn;
        return this;
    }
}

