/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.client.render;

import com.github.alexthe666.alexsmobs.client.model.ModelSpectre;
import com.github.alexthe666.alexsmobs.client.render.AMRenderTypes;
import com.github.alexthe666.alexsmobs.entity.EntitySpectre;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.AbstractEyesLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class RenderSpectre
extends MobRenderer<EntitySpectre, ModelSpectre> {
    private static final ResourceLocation TEXTURE_BONE = new ResourceLocation("alexsmobs:textures/entity/spectre_bone.png");
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexsmobs:textures/entity/spectre.png");
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("alexsmobs:textures/entity/spectre_glow.png");
    private static final ResourceLocation TEXTURE_LEAD = new ResourceLocation("alexsmobs:textures/entity/spectre_lead.png");

    public RenderSpectre(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, (EntityModel)new ModelSpectre(), 0.5f);
        this.func_177094_a((LayerRenderer)new SpectreEyesLayer(this));
        this.func_177094_a(new SpectreMembraneLayer(this));
    }

    protected void preRenderCallback(EntitySpectre entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
        matrixStackIn.func_227862_a_(1.3f, 1.3f, 1.3f);
    }

    protected int getBlockLight(EntitySpectre entityIn, BlockPos partialTicks) {
        return 15;
    }

    public ResourceLocation getEntityTexture(EntitySpectre entity) {
        return TEXTURE_BONE;
    }

    public float getAlphaForRender(EntitySpectre entityIn, float partialTicks) {
        return ((float)Math.sin(((float)entityIn.field_70173_aa + partialTicks) * 0.1f) + 1.5f) * 0.1f + 0.5f;
    }

    class SpectreMembraneLayer
    extends LayerRenderer<EntitySpectre, ModelSpectre> {
        public SpectreMembraneLayer(RenderSpectre p_i50928_1_) {
            super((IEntityRenderer)p_i50928_1_);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, EntitySpectre entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder lvt_11_1_ = bufferIn.getBuffer(this.getRenderType());
            ((ModelSpectre)this.func_215332_c()).func_225598_a_(matrixStackIn, lvt_11_1_, 0xF00000, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, RenderSpectre.this.getAlphaForRender(entitylivingbaseIn, partialTicks));
            if (entitylivingbaseIn.func_110167_bD()) {
                IVertexBuilder lead = bufferIn.getBuffer(AMRenderTypes.func_228640_c_((ResourceLocation)TEXTURE_LEAD));
                ((ModelSpectre)this.func_215332_c()).func_225598_a_(matrixStackIn, lead, 0xF00000, LivingRenderer.func_229117_c_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }

        public RenderType getRenderType() {
            return AMRenderTypes.getGhost(TEXTURE);
        }
    }

    class SpectreEyesLayer
    extends AbstractEyesLayer<EntitySpectre, ModelSpectre> {
        public SpectreEyesLayer(RenderSpectre p_i50928_1_) {
            super((IEntityRenderer)p_i50928_1_);
        }

        public RenderType func_225636_a_() {
            return RenderType.func_228652_i_((ResourceLocation)TEXTURE_EYES);
        }
    }
}

