/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry.forge;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.architectury.platform.forge.EventBuses;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ColorHandlersImpl {
    private static final List<Pair<IItemColor, Supplier<? extends IItemProvider>[]>> ITEM_COLORS = Lists.newArrayList();
    private static final List<Pair<IBlockColor, Supplier<? extends Block>[]>> BLOCK_COLORS = Lists.newArrayList();

    @SubscribeEvent
    public static void onItemColorEvent(ColorHandlerEvent.Item event) {
        for (Pair<IItemColor, Supplier<? extends IItemProvider>[]> pair : ITEM_COLORS) {
            event.getItemColors().func_199877_a((IItemColor)pair.getLeft(), ColorHandlersImpl.unpackItems((Supplier[])pair.getRight()));
        }
    }

    @SubscribeEvent
    public static void onBlockColorEvent(ColorHandlerEvent.Block event) {
        for (Pair<IBlockColor, Supplier<? extends Block>[]> pair : BLOCK_COLORS) {
            event.getBlockColors().func_186722_a((IBlockColor)pair.getLeft(), ColorHandlersImpl.unpackBlocks((Supplier[])pair.getRight()));
        }
    }

    @SafeVarargs
    public static void registerItemColors(IItemColor itemColor, Supplier<? extends IItemProvider> ... items) {
        Objects.requireNonNull(itemColor, "color is null!");
        if (Minecraft.func_71410_x().getItemColors() == null) {
            ITEM_COLORS.add((Pair<IItemColor, Supplier<? extends IItemProvider>[]>)Pair.of((Object)itemColor, items));
        } else {
            Minecraft.func_71410_x().getItemColors().func_199877_a(itemColor, ColorHandlersImpl.unpackItems(items));
        }
    }

    @SafeVarargs
    public static void registerBlockColors(IBlockColor blockColor, Supplier<? extends Block> ... blocks) {
        Objects.requireNonNull(blockColor, "color is null!");
        if (Minecraft.func_71410_x().func_184125_al() == null) {
            BLOCK_COLORS.add((Pair<IBlockColor, Supplier<? extends Block>[]>)Pair.of((Object)blockColor, blocks));
        } else {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(blockColor, ColorHandlersImpl.unpackBlocks(blocks));
        }
    }

    private static IItemProvider[] unpackItems(Supplier<? extends IItemProvider>[] items) {
        IItemProvider[] array = new IItemProvider[items.length];
        for (int i = 0; i < items.length; ++i) {
            array[i] = Objects.requireNonNull(items[i].get());
        }
        return array;
    }

    private static Block[] unpackBlocks(Supplier<? extends Block>[] blocks) {
        Block[] array = new Block[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            array[i] = Objects.requireNonNull(blocks[i].get());
        }
        return array;
    }

    static {
        EventBuses.onRegistered("architectury", bus -> bus.register(ColorHandlersImpl.class));
    }
}

