/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.fluid;

import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.architectury.hooks.FluidStackHooks;
import me.shedaniel.architectury.utils.Fraction;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public final class FluidStack {
    private static final FluidStack EMPTY = FluidStack.create(Fluids.field_204541_a, Fraction.zero());
    private Fraction amount;
    @Nullable
    private CompoundNBT tag;
    private Supplier<Fluid> fluid;

    private FluidStack(Supplier<Fluid> fluid, Fraction amount, CompoundNBT tag) {
        this.fluid = Objects.requireNonNull(fluid);
        this.amount = Objects.requireNonNull(amount);
        this.tag = tag == null ? null : tag.func_74737_b();
    }

    public static FluidStack empty() {
        return EMPTY;
    }

    public static FluidStack create(Fluid fluid, Fraction amount, @Nullable CompoundNBT tag) {
        return FluidStack.create(() -> fluid, amount, tag);
    }

    public static FluidStack create(Fluid fluid, Fraction amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(Supplier<Fluid> fluid, Fraction amount, @Nullable CompoundNBT tag) {
        return new FluidStack(fluid, amount, tag);
    }

    public static FluidStack create(Supplier<Fluid> fluid, Fraction amount) {
        return FluidStack.create(fluid, amount, null);
    }

    public static FluidStack create(FluidStack stack, Fraction amount) {
        return FluidStack.create(stack.getRawFluidSupplier(), amount, stack.getTag());
    }

    public static Fraction bucketAmount() {
        return FluidStackHooks.bucketAmount();
    }

    public final Fluid getFluid() {
        return this.isEmpty() ? Fluids.field_204541_a : this.getRawFluid();
    }

    @Nullable
    public final Fluid getRawFluid() {
        return this.fluid.get();
    }

    public final Supplier<Fluid> getRawFluidSupplier() {
        return this.fluid;
    }

    public boolean isEmpty() {
        return this.getRawFluid() == Fluids.field_204541_a || !this.amount.isGreaterThan(Fraction.zero());
    }

    public Fraction getAmount() {
        return this.isEmpty() ? Fraction.zero() : this.amount;
    }

    public void setAmount(Fraction amount) {
        this.amount = Objects.requireNonNull(amount);
    }

    public void grow(Fraction amount) {
        this.setAmount(this.amount.add(amount));
    }

    public void shrink(Fraction amount) {
        this.setAmount(this.amount.minus(amount));
    }

    public boolean hasTag() {
        return this.tag != null;
    }

    @Nullable
    public CompoundNBT getTag() {
        return this.tag;
    }

    public void setTag(@Nullable CompoundNBT tag) {
        this.tag = tag;
    }

    public CompoundNBT getOrCreateTag() {
        if (this.tag == null) {
            this.setTag(new CompoundNBT());
        }
        return this.tag;
    }

    @Nullable
    public CompoundNBT getChildTag(String childName) {
        if (this.tag == null) {
            return null;
        }
        return this.tag.func_74775_l(childName);
    }

    public CompoundNBT getOrCreateChildTag(String childName) {
        this.getOrCreateTag();
        CompoundNBT child = this.tag.func_74775_l(childName);
        if (!this.tag.func_150297_b(childName, 10)) {
            this.tag.func_218657_a(childName, (INBT)child);
        }
        return child;
    }

    public void removeChildTag(String childName) {
        if (this.tag != null) {
            this.tag.func_82580_o(childName);
        }
    }

    public ITextComponent getName() {
        return FluidStackHooks.getName(this);
    }

    public String getTranslationKey() {
        return FluidStackHooks.getTranslationKey(this);
    }

    public FluidStack copy() {
        return new FluidStack(this.fluid, this.amount, this.tag);
    }

    public final int hashCode() {
        int code = 1;
        code = 31 * code + this.getFluid().hashCode();
        code = 31 * code + this.amount.hashCode();
        if (this.tag != null) {
            code = 31 * code + this.tag.hashCode();
        }
        return code;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof FluidStack)) {
            return false;
        }
        return this.isFluidStackEqual((FluidStack)o);
    }

    public boolean isFluidStackEqual(FluidStack other) {
        return this.getFluid() == other.getFluid() && this.getAmount().equals(other.getAmount()) && this.isTagEqual(other);
    }

    private boolean isTagEqual(FluidStack other) {
        return this.tag == null ? other.tag == null : other.tag != null && this.tag.equals((Object)other.tag);
    }

    public static FluidStack read(PacketBuffer buf) {
        return FluidStackHooks.read(buf);
    }

    public static FluidStack read(CompoundNBT tag) {
        return FluidStackHooks.read(tag);
    }

    public void write(PacketBuffer buf) {
        FluidStackHooks.write(this, buf);
    }

    public CompoundNBT write(CompoundNBT tag) {
        return FluidStackHooks.write(this, tag);
    }
}

