/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.rendering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.network.ThrowableIdentity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class RenderHelper {
    public static float rot = 0.0f;

    public static void renderEntity(Entity entity, MatrixStack matrixStack, int xPos, int yPos, float scale) {
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        matrixStack.func_227861_a_((double)(xPos + 8), (double)(yPos + 24), 50.0);
        matrixStack.func_227862_a_(-scale, scale, scale);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(180.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(135.0f));
        net.minecraft.client.renderer.RenderHelper.func_227780_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-135.0f));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rot));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(0.0f));
        if (!(entity instanceof PlayerEntity)) {
            entity.field_70125_A = 0.0f;
            entity.field_70127_C = 0.0f;
            entity.field_70177_z = 0.0f;
            entity.field_70126_B = 0.0f;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.field_70760_ar = 0.0f;
                livingEntity.field_70761_aq = 0.0f;
                livingEntity.field_70759_as = 0.0f;
                livingEntity.field_70758_at = 0.0f;
            }
        }
        matrixStack.func_227861_a_(0.0, (double)((float)entity.func_70033_W() + (entity instanceof HangingEntity ? 0.5f : 0.0f)), 0.0);
        EntityRendererManager dispatcher = Minecraft.func_71410_x().func_175598_ae();
        try {
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            dispatcher.func_178633_a(false);
            dispatcher.func_229084_a_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)buffer, 0xF000F0);
            buffer.func_228461_a_();
        }
        catch (Exception e) {
            TheOneProbe.logger.error("Error rendering entity!", (Throwable)e);
        }
        dispatcher.func_178633_a(true);
        net.minecraft.client.renderer.RenderHelper.func_74518_a();
        RenderSystem.disableRescaleNormal();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.disableColorMaterial();
        Minecraft.func_71410_x().field_71460_t.func_228384_l_().func_205108_b();
        matrixStack.func_227865_b_();
    }

    public static void drawHorizontalLine(MatrixStack matrixStack, int x1, int y1, int x2, int color) {
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)x2, (int)(y1 + 1), (int)color);
    }

    public static void drawVerticalLine(MatrixStack matrixStack, int x1, int y1, int y2, int color) {
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)(x1 + 1), (int)y2, (int)color);
    }

    public static void drawThickBeveledBox(MatrixStack matrixStack, int x1, int y1, int x2, int y2, int thickness, int topleftcolor, int botrightcolor, int fillcolor) {
        if (fillcolor != -1) {
            AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x1 + 1), (int)(y1 + 1), (int)(x2 - 1), (int)(y2 - 1), (int)fillcolor);
        }
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)(x2 - 1), (int)(y1 + thickness), (int)topleftcolor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)y1, (int)(x1 + thickness), (int)(y2 - 1), (int)topleftcolor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)(x2 - thickness), (int)y1, (int)x2, (int)(y2 - 1), (int)botrightcolor);
        AbstractGui.func_238467_a_((MatrixStack)matrixStack, (int)x1, (int)(y2 - thickness), (int)x2, (int)y2, (int)botrightcolor);
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, int u, int v, int width, int height, int twidth, int theight) {
        float zLevel = 0.01f;
        float f = 1.0f / (float)twidth;
        float f1 = 1.0f / (float)theight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, (float)(x + 0), (float)(y + height), zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + height), zLevel).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + 0), zLevel).func_225583_a_((float)(u + width) * f, (float)(v + 0) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + 0), (float)(y + 0), zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, int u, int v, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, (float)(x + 0), (float)(y + height), zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + height), zLevel).func_225583_a_((float)(u + width) * f, (float)(v + height) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + 0), zLevel).func_225583_a_((float)(u + width) * f, (float)(v + 0) * f1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + 0), (float)(y + 0), zLevel).func_225583_a_((float)(u + 0) * f, (float)(v + 0) * f1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawTexturedModalRect(Matrix4f matrix, int x, int y, TextureAtlasSprite sprite, int width, int height) {
        float zLevel = 0.01f;
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        float u1 = sprite.func_94209_e();
        float v1 = sprite.func_94206_g();
        float u2 = sprite.func_94212_f();
        float v2 = sprite.func_94210_h();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_227888_a_(matrix, (float)(x + 0), (float)(y + height), zLevel).func_225583_a_(u1, v1).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + height), zLevel).func_225583_a_(u1, v2).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + width), (float)(y + 0), zLevel).func_225583_a_(u2, v2).func_181675_d();
        buffer.func_227888_a_(matrix, (float)(x + 0), (float)(y + 0), zLevel).func_225583_a_(u2, v1).func_181675_d();
        tessellator.func_78381_a();
    }

    public static boolean renderItemStack(Minecraft mc, ItemRenderer itemRender, ItemStack itm, MatrixStack matrixStack, int x, int y, String txt) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean rc = true;
        if (!itm.func_190926_b() && itm.func_77973_b() != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 0.0, 32.0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableLighting();
            int short1 = 240;
            int short2 = 240;
            net.minecraft.client.renderer.RenderHelper.func_227784_d_();
            try {
                RenderSystem.pushMatrix();
                RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
                itemRender.func_180450_b(itm, x, y);
                RenderSystem.popMatrix();
                RenderHelper.renderItemStackOverlay(matrixStack, mc.field_71466_p, itm, x, y, txt, txt.length() - 2);
            }
            catch (Exception e) {
                ThrowableIdentity.registerThrowable(e);
                rc = false;
            }
            matrixStack.func_227865_b_();
            RenderSystem.disableRescaleNormal();
            RenderSystem.disableLighting();
        }
        return rc;
    }

    public static void renderItemStackOverlay(MatrixStack matrixStack, FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text, int scaled) {
        if (!stack.func_190926_b()) {
            ClientPlayerEntity PlayerEntitysp;
            float f;
            if (stack.func_190916_E() != 1 || text != null) {
                String s;
                String string = s = text == null ? String.valueOf(stack.func_190916_E()) : text;
                if (text == null && stack.func_190916_E() < 1) {
                    s = TextFormatting.RED + String.valueOf(stack.func_190916_E());
                }
                matrixStack.func_227861_a_(0.0, 0.0, (double)(Minecraft.func_71410_x().func_175599_af().field_77023_b + 200.0f));
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                if (scaled >= 2) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
                    fr.func_238405_a_(matrixStack, s, (float)((xPosition + 19 - 2) * 2 - 1 - fr.func_78256_a(s)), (float)(yPosition * 2 + 24), 0xFFFFFF);
                    matrixStack.func_227865_b_();
                } else if (scaled == 1) {
                    matrixStack.func_227860_a_();
                    matrixStack.func_227862_a_(0.75f, 0.75f, 0.75f);
                    fr.func_238405_a_(matrixStack, s, (float)(xPosition - 2) * 1.34f + 24.0f - (float)fr.func_78256_a(s), (float)yPosition * 1.34f + 14.0f, 0xFFFFFF);
                    matrixStack.func_227865_b_();
                } else {
                    fr.func_238405_a_(matrixStack, s, (float)(xPosition + 19 - 2 - fr.func_78256_a(s)), (float)(yPosition + 6 + 3), 0xFFFFFF);
                }
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
            }
            if (stack.func_77973_b().showDurabilityBar(stack)) {
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer = tessellator.func_178180_c();
                Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
                RenderHelper.draw(vertexbuffer, matrix, xPosition + 2, yPosition + 13, 13, 2, 0, 0, 0, 255);
                RenderHelper.draw(vertexbuffer, matrix, xPosition + 2, yPosition + 13, 12, 1, (255 - i) / 4, 64, 0, 255);
                RenderHelper.draw(vertexbuffer, matrix, xPosition + 2, yPosition + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
            }
            float f2 = f = (PlayerEntitysp = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : PlayerEntitysp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f > 0.0f) {
                RenderSystem.disableLighting();
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder vertexbuffer1 = tessellator1.func_178180_c();
                RenderHelper.draw(vertexbuffer1, matrixStack.func_227866_c_().func_227870_a_(), xPosition, yPosition + (int)Math.floor(16.0f * (1.0f - f)), 16, (int)Math.ceil(16.0f * f), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableLighting();
                RenderSystem.enableDepthTest();
            }
        }
    }

    private static void draw(BufferBuilder renderer, Matrix4f matrix, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_227888_a_(matrix, (float)(x + 0), (float)(y + 0), 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix, (float)(x + 0), (float)(y + height), 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix, (float)(x + width), (float)(y + height), 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        renderer.func_227888_a_(matrix, (float)(x + width), (float)(y + 0), 0.0f).func_225586_a_(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static int renderText(Minecraft mc, MatrixStack matrixStack, int x, int y, String txt) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.0, 0.0, 32.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableLighting();
        net.minecraft.client.renderer.RenderHelper.func_227784_d_();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        int width = mc.field_71466_p.func_78256_a(txt);
        mc.field_71466_p.func_238405_a_(matrixStack, txt, (float)x, (float)y, 0xFFFFFF);
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        matrixStack.func_227865_b_();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        return width;
    }

    public static int renderText(Minecraft mc, MatrixStack stack, int x, int y, ITextComponent text) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.func_227860_a_();
        stack.func_227861_a_(0.0, 0.0, 32.0);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableLighting();
        net.minecraft.client.renderer.RenderHelper.func_227784_d_();
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        int width = mc.field_71466_p.func_243245_a(text.func_241878_f());
        mc.field_71466_p.func_238407_a_(stack, text.func_241878_f(), (float)x, (float)y, 0xFFFFFF);
        RenderSystem.enableLighting();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        stack.func_227865_b_();
        RenderSystem.disableRescaleNormal();
        RenderSystem.disableLighting();
        return width;
    }

    private static Vector Cross(Vector a, Vector b) {
        float x = a.y * b.z - a.z * b.y;
        float y = a.z * b.x - a.x * b.z;
        float z = a.x * b.y - a.y * b.x;
        return new Vector(x, y, z);
    }

    private static Vector Sub(Vector a, Vector b) {
        return new Vector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    private static Vector Add(Vector a, Vector b) {
        return new Vector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    private static Vector Mul(Vector a, float f) {
        return new Vector(a.x * f, a.y * f, a.z * f);
    }

    public static class Vector {
        public final float x;
        public final float y;
        public final float z;

        public Vector(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float norm() {
            return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
        }

        public Vector normalize() {
            float n = this.norm();
            return new Vector(this.x / n, this.y / n, this.z / n);
        }
    }
}

