/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.apiimpl.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IProgressStyle;
import mcjty.theoneprobe.api.NumberFormat;
import mcjty.theoneprobe.api.TankReference;
import mcjty.theoneprobe.apiimpl.TheOneProbeImp;
import mcjty.theoneprobe.apiimpl.client.ElementProgressRender;
import mcjty.theoneprobe.apiimpl.styles.ProgressStyle;
import net.minecraft.network.PacketBuffer;

public class ElementTank
implements IElement {
    private final TankReference tank;
    private final IProgressStyle style;

    public ElementTank(TankReference tank) {
        this(tank, new ProgressStyle());
    }

    public ElementTank(TankReference tank, IProgressStyle style) {
        this.tank = tank;
        this.style = style;
    }

    public ElementTank(PacketBuffer buffer) {
        this.tank = new TankReference(buffer);
        this.style = new ProgressStyle().width(buffer.readInt()).height(buffer.readInt()).prefix(buffer.func_179258_d()).suffix(buffer.func_179258_d()).borderColor(buffer.readInt()).filledColor(buffer.readInt()).alternateFilledColor(buffer.readInt()).backgroundColor(buffer.readInt()).showText(buffer.readBoolean()).numberFormat(NumberFormat.values()[buffer.readByte()]).lifeBar(buffer.readBoolean()).armorBar(buffer.readBoolean()).alignment((ElementAlignment)buffer.func_179257_a(ElementAlignment.class));
    }

    public IProgressStyle getStyle() {
        return this.style;
    }

    @Override
    public void render(MatrixStack matrixStack, int x, int y) {
        ElementProgressRender.renderTank(matrixStack, x, y, this.getWidth(), this.getHeight(), this.style, this.tank);
    }

    @Override
    public int getWidth() {
        return this.style.getWidth();
    }

    @Override
    public int getHeight() {
        return this.style.getHeight();
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        this.tank.toBytes(buf);
        buf.writeInt(this.style.getWidth());
        buf.writeInt(this.style.getHeight());
        buf.func_179256_a(this.style.getPrefixComp());
        buf.func_179256_a(this.style.getSuffixComp());
        buf.writeInt(this.style.getBorderColor());
        buf.writeInt(this.style.getFilledColor());
        buf.writeInt(this.style.getAlternatefilledColor());
        buf.writeInt(this.style.getBackgroundColor());
        buf.writeBoolean(this.style.isShowText());
        buf.writeByte(this.style.getNumberFormat().ordinal());
        buf.writeBoolean(this.style.isLifeBar());
        buf.writeBoolean(this.style.isArmorBar());
        buf.func_179249_a((Enum)this.style.getAlignment());
    }

    @Override
    public int getID() {
        return TheOneProbeImp.ELEMENT_TANK;
    }
}

