/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class BlockStandardDrawers
extends BlockDrawers {
    public BlockStandardDrawers(int drawerCount, boolean halfDepth, int storageUnits, AbstractBlock.Properties properties) {
        super(drawerCount, halfDepth, storageUnits, properties);
    }

    public BlockStandardDrawers(int drawerCount, boolean halfDepth, AbstractBlock.Properties properties) {
        super(drawerCount, halfDepth, BlockStandardDrawers.calcUnits(drawerCount, halfDepth), properties);
    }

    private static int calcUnits(int drawerCount, boolean halfDepth) {
        return halfDepth ? 4 / drawerCount : 8 / drawerCount;
    }

    @Override
    protected int getDrawerSlot(Direction side, Vector3d hit) {
        if (this.getDrawerCount() == 1) {
            return 0;
        }
        if (this.getDrawerCount() == 2) {
            return this.hitTop(hit.field_72448_b) ? 0 : 1;
        }
        if (this.hitLeft(side, hit.field_72450_a, hit.field_72449_c)) {
            return this.hitTop(hit.field_72448_b) ? 0 : 2;
        }
        return this.hitTop(hit.field_72448_b) ? 1 : 3;
    }

    public TileEntityDrawers createTileEntity(BlockState state, IBlockReader world) {
        return TileEntityDrawersStandard.createEntity(this.getDrawerCount());
    }
}

