/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.EnumKeyType;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockController
extends HorizontalBlock
implements INetworked {
    public BlockController(AbstractBlock.Properties properties) {
        super(properties);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        Direction blockDir = (Direction)state.func_177229_b((Property)field_185512_D);
        TileEntityController te = this.getTileEntitySafe(world, pos);
        ItemStack item = player.field_71071_by.func_70448_g();
        if (!item.func_190926_b() && this.toggle(world, pos, player, item.func_77973_b())) {
            return ActionResultType.SUCCESS;
        }
        if (blockDir != hit.func_216354_b()) {
            return ActionResultType.CONSUME;
        }
        if (!world.field_72995_K) {
            if (((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue() && item.func_190926_b()) {
                te.printDebugInfo();
            }
            te.interactPutItemsIntoInventory(player);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean toggle(World world, BlockPos pos, PlayerEntity player, Item item) {
        if (world.field_72995_K || item == null) {
            return false;
        }
        if (item == ModItems.DRAWER_KEY) {
            this.toggle(world, pos, player, EnumKeyType.DRAWER);
        } else if (item == ModItems.SHROUD_KEY) {
            this.toggle(world, pos, player, EnumKeyType.CONCEALMENT);
        } else if (item == ModItems.QUANTIFY_KEY) {
            this.toggle(world, pos, player, EnumKeyType.QUANTIFY);
        } else {
            return false;
        }
        return true;
    }

    public void toggle(World world, BlockPos pos, PlayerEntity player, EnumKeyType keyType) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityController te = this.getTileEntitySafe(world, pos);
        if (te == null) {
            return;
        }
        switch (keyType) {
            case DRAWER: {
                te.toggleLock(EnumSet.allOf(LockAttribute.class), LockAttribute.LOCK_POPULATED, player.func_146103_bH());
                break;
            }
            case CONCEALMENT: {
                te.toggleShroud(player.func_146103_bH());
                break;
            }
            case QUANTIFY: {
                te.toggleQuantified(player.func_146103_bH());
            }
        }
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityController te = this.getTileEntitySafe((World)world, pos);
        if (te == null) {
            return;
        }
        te.updateCache();
        world.func_205220_G_().func_205360_a(pos, (Object)this, 100);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntityController createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityController();
    }

    public TileEntityController getTileEntity(IBlockReader blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        return tile instanceof TileEntityController ? (TileEntityController)tile : null;
    }

    public TileEntityController getTileEntitySafe(World world, BlockPos pos) {
        TileEntityController tile = this.getTileEntity((IBlockReader)world, pos);
        if (tile == null) {
            tile = this.createTileEntity(world.func_180495_p(pos), (IBlockReader)world);
            world.func_175690_a(pos, (TileEntity)tile);
        }
        return tile;
    }
}

