/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.shader;

import com.jozufozu.flywheel.backend.ShaderContext;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.core.shader.ExtensibleGlProgram;
import com.jozufozu.flywheel.core.shader.IMultiProgram;
import com.jozufozu.flywheel.core.shader.spec.IContextCondition;
import com.jozufozu.flywheel.core.shader.spec.ProgramSpec;
import com.jozufozu.flywheel.core.shader.spec.ProgramState;
import com.jozufozu.flywheel.util.Pair;
import java.util.ArrayList;
import java.util.List;

public class StateSensitiveMultiProgram<P extends GlProgram>
implements IMultiProgram<P> {
    List<Pair<IContextCondition, P>> variants;
    P fallback;

    public StateSensitiveMultiProgram(ExtensibleGlProgram.Factory<P> factory, ShaderContext<P> context, ProgramSpec p) {
        this.variants = new ArrayList<Pair<IContextCondition, P>>(p.states.size());
        for (ProgramState state : p.states) {
            Program variant = context.loadAndLink(p, state);
            Pair<IContextCondition, P> pair = Pair.of(state.getContext(), factory.create(variant, state.getExtensions()));
            this.variants.add(pair);
        }
        this.fallback = factory.create(context.loadAndLink(p, null));
    }

    @Override
    public P get() {
        for (Pair<IContextCondition, P> variant : this.variants) {
            if (!variant.getFirst().get()) continue;
            return (P)((GlProgram)variant.getSecond());
        }
        return this.fallback;
    }

    @Override
    public void delete() {
        for (Pair<IContextCondition, P> variant : this.variants) {
            ((GlProgram)variant.getSecond()).delete();
        }
        ((GlObject)this.fallback).delete();
    }
}

