/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl;

public abstract class GlObject {
    private static final int INVALID_HANDLE = Integer.MIN_VALUE;
    private int handle = Integer.MIN_VALUE;

    protected final void setHandle(int handle) {
        this.handle = handle;
    }

    public final int handle() {
        this.checkHandle();
        return this.handle;
    }

    protected final void checkHandle() {
        if (!this.isHandleValid()) {
            String descriptor = this.getDescriptor();
            String message = (descriptor == null ? "" : descriptor + " ") + "handle is not valid.";
            throw new IllegalStateException(message);
        }
    }

    protected final boolean isHandleValid() {
        return this.handle != Integer.MIN_VALUE;
    }

    protected final void invalidateHandle() {
        this.handle = Integer.MIN_VALUE;
    }

    public void delete() {
        if (!this.isHandleValid()) {
            String descriptor = this.getDescriptor();
            String message = (descriptor == null ? "" : descriptor + " ") + "handle already deleted.";
            throw new IllegalStateException(message);
        }
        this.deleteInternal(this.handle);
        this.invalidateHandle();
    }

    protected abstract void deleteInternal(int var1);

    protected String getDescriptor() {
        return "";
    }
}

