/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.IShaderContext;
import com.jozufozu.flywheel.backend.gl.GlObject;
import com.jozufozu.flywheel.backend.gl.shader.GlProgram;
import com.jozufozu.flywheel.backend.gl.shader.GlShader;
import com.jozufozu.flywheel.backend.gl.shader.ShaderType;
import com.jozufozu.flywheel.backend.loading.Program;
import com.jozufozu.flywheel.backend.loading.Shader;
import com.jozufozu.flywheel.core.shader.IMultiProgram;
import com.jozufozu.flywheel.core.shader.spec.ProgramSpec;
import com.jozufozu.flywheel.core.shader.spec.ProgramState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public abstract class ShaderContext<P extends GlProgram>
implements IShaderContext<P> {
    protected final Map<ResourceLocation, IMultiProgram<P>> programs = new HashMap<ResourceLocation, IMultiProgram<P>>();
    public final Backend backend;

    public ShaderContext(Backend backend) {
        this.backend = backend;
    }

    @Override
    public Supplier<P> getProgramSupplier(ResourceLocation spec) {
        return this.programs.get(spec);
    }

    public Program loadAndLink(ProgramSpec spec, @Nullable ProgramState state) {
        Shader vertexFile = this.getSource(ShaderType.VERTEX, spec.vert);
        Shader fragmentFile = this.getSource(ShaderType.FRAGMENT, spec.frag);
        if (state != null) {
            vertexFile.defineAll(state.getDefines());
            fragmentFile.defineAll(state.getDefines());
        }
        Program linked = this.link(ShaderContext.buildProgram(spec.name, vertexFile, fragmentFile));
        String descriptor = linked.program + ": " + spec.name;
        if (state != null) {
            descriptor = descriptor + "#" + state;
        }
        Backend.log.debug(descriptor);
        return linked;
    }

    protected Shader getSource(ShaderType type, ResourceLocation name) {
        return this.backend.sources.source(name, type);
    }

    protected Program link(Program program) {
        return program.link().deleteLinkedShaders();
    }

    @Override
    public void delete() {
        this.programs.values().forEach(IMultiProgram::delete);
        this.programs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Program buildProgram(ResourceLocation name, Shader ... shaders) {
        ArrayList<GlShader> compiled = new ArrayList<GlShader>(shaders.length);
        try {
            Program builder = new Program(name);
            for (Shader shader : shaders) {
                GlShader sh = new GlShader(shader);
                compiled.add(sh);
                builder.attachShader(shader, sh);
            }
            Program program = builder;
            return program;
        }
        finally {
            compiled.forEach(GlObject::delete);
        }
    }
}

